/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.asynccontext;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import servlet.tck.api.jakarta_servlet_http.asynccontext.ACListener;
import servlet.tck.api.jakarta_servlet_http.asynccontext.ACListener2;
import servlet.tck.api.jakarta_servlet_http.asynccontext.ACListenerBad;
import servlet.tck.api.jakarta_servlet_http.asynccontext.RequestWrapper;
import servlet.tck.api.jakarta_servlet_http.asynccontext.ResponseWrapper;
import servlet.tck.common.servlets.HttpTCKServlet;

public class AsyncTestServlet
extends HttpTCKServlet {
    public void dispatchZeroArgTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String where = (String)request.getAttribute("WHERE");
        if ("ASYNC".equals(where)) {
            response.getWriter().println("ASYNC_STARTED_dispatchZeroArgTest");
            response.getWriter().println("IsAsyncSupported=" + request.isAsyncSupported());
            response.getWriter().println("IsAsyncStarted=" + request.isAsyncStarted());
            response.getWriter().println("DispatcherType=" + request.getDispatcherType());
        } else {
            response.getWriter().println("ASYNC_NOT_STARTED_dispatchZeroArgTest");
            response.getWriter().println("IsAsyncSupported=" + request.isAsyncSupported());
            response.getWriter().println("IsAsyncStarted=" + request.isAsyncStarted());
            response.getWriter().println("DispatcherType=" + request.getDispatcherType());
            AsyncContext ac = request.startAsync();
            request.setAttribute("WHERE", (Object)"ASYNC");
            ac.dispatch();
        }
    }

    public void dispatchContextPathTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = "/async/AsyncTests?testname=asyncTest";
        response.getWriter().println("ASYNC_NOT_STARTED_dispatchContextPathTest");
        response.getWriter().println("IsAsyncSupported=" + request.isAsyncSupported());
        response.getWriter().println("IsAsyncStarted=" + request.isAsyncStarted());
        response.getWriter().println("DispatcherType=" + request.getDispatcherType());
        AsyncContext ac = request.startAsync();
        ac.dispatch(request.getServletContext(), path);
    }

    public void getRequestTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = "/async/AsyncTests?testname=asyncTest";
        AsyncContext ac = request.startAsync();
        if (ac.getRequest() == request) {
            response.getWriter().println("getRequest() worked.  Test PASSED.");
        } else {
            response.getWriter().println("getRequest() didnot work as expected.  Test FAILED.");
        }
        ac.complete();
    }

    public void asyncListenerTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext ac = request.startAsync();
        AsyncListener acl = ac.createListener(ACListener.class);
        ac.addListener(acl);
        ac.complete();
    }

    public void timeOutTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long timeout_set = 5015L;
        AsyncContext ac = request.startAsync();
        response.getWriter().println("Default timeout: " + ac.getTimeout());
        ac.setTimeout(timeout_set);
        long timeout_actual = ac.getTimeout();
        if (timeout_actual == timeout_set) {
            response.getWriter().println("Test PASSED.");
        } else {
            response.getWriter().println("Test FAILED.  setTimeout to " + timeout_set);
            response.getWriter().println("getTimeout returned " + timeout_actual);
        }
        ac.complete();
    }

    public void timeOutTest1(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long timeout_set = 5015L;
        AsyncContext ac = request.startAsync();
        response.getWriter().println("Default timeout: " + ac.getTimeout());
        AsyncListener acl2 = ac.createListener(ACListener2.class);
        ac.addListener(acl2);
        ac.setTimeout(timeout_set);
        try {
            Thread.sleep(timeout_set * 2L);
        }
        catch (InterruptedException ex) {
            response.getWriter().println("Test FAILED with exception: " + ex.getMessage());
        }
    }

    public void asyncListenerTest1(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long timeout_set = 5015L;
        AsyncContext ac = request.startAsync();
        response.getWriter().println("Default timeout: " + ac.getTimeout());
        try {
            AsyncListener acl = ac.createListener(ACListenerBad.class);
            response.getWriter().println("Test FAILED without throwing expected exception.");
        }
        catch (ServletException ex) {
            response.getWriter().println("Test PASSED with exception: " + ex.getMessage());
        }
        catch (Exception ex1) {
            response.getWriter().println("Test FAILED with wrong type exception: " + ex1.getMessage());
        }
        ac.complete();
    }

    public void asyncListenerTest2(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext ac = request.startAsync();
        AsyncListener acl = ac.createListener(ACListener.class);
        ac.addListener(acl, (ServletRequest)request, (ServletResponse)response);
        ac.complete();
    }

    public void originalRequestTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext ac = request.startAsync();
        if (ac.hasOriginalRequestAndResponse()) {
            response.getWriter().println("Test PASSED. AsyncContext.hasOriginalRequestAndRespons()=true");
        } else {
            response.getWriter().println("Test FAILED. AsyncContext.hasOriginalRequestAndRespons()=false");
        }
        ac.complete();
    }

    public void originalRequestTest1(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext ac = request.startAsync((ServletRequest)request, (ServletResponse)response);
        if (ac.hasOriginalRequestAndResponse()) {
            response.getWriter().println("Test PASSED. AsyncContext.hasOriginalRequestAndRespons()=true");
        } else {
            response.getWriter().println("Test FAILED. AsyncContext.hasOriginalRequestAndRespons()=false");
        }
        ac.complete();
    }

    public void originalRequestTest2(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext ac = request.startAsync((ServletRequest)new RequestWrapper(request), (ServletResponse)new ResponseWrapper(response));
        if (ac.hasOriginalRequestAndResponse()) {
            response.getWriter().println("Test FAILED. AsyncContext.hasOriginalRequestAndRespons()=true");
        } else {
            response.getWriter().println("Test PASSED. AsyncContext.hasOriginalRequestAndRespons()=false");
        }
        ac.complete();
    }

    public void originalRequestTest3(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext ac = request.startAsync((ServletRequest)new RequestWrapper(request), (ServletResponse)response);
        if (ac.hasOriginalRequestAndResponse()) {
            response.getWriter().println("Test FAILED. AsyncContext.hasOriginalRequestAndRespons()=true");
        } else {
            response.getWriter().println("Test PASSED. AsyncContext.hasOriginalRequestAndRespons()=false");
        }
        ac.complete();
    }

    public void originalRequestTest4(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext ac = request.startAsync((ServletRequest)request, (ServletResponse)new ResponseWrapper(response));
        if (ac.hasOriginalRequestAndResponse()) {
            response.getWriter().println("Test FAILED. AsyncContext.hasOriginalRequestAndRespons()=true");
        } else {
            response.getWriter().println("Test PASSED. AsyncContext.hasOriginalRequestAndRespons()=false");
        }
        ac.complete();
    }
}

