/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial.handlers;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.examples.common.navigator.nodes.EClassesNode;
import org.eclipse.graphiti.examples.tutorial.Messages;
import org.eclipse.graphiti.examples.tutorial.handlers.AddAllClassesCommand;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public final class CreateDiagramWithAllClassesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object first = ((IStructuredSelection)selection).getFirstElement();
        if (!(first instanceof EClassesNode)) {
            return null;
        }
        EClassesNode node = (EClassesNode)first;
        IProject project = node.getProject();
        if (project == null) {
            return null;
        }
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.CreateDiagramWithAllClassesHandler_NewDiagramTitle, Messages.CreateDiagramWithAllClassesHandler_NewDiagramDescription, null, null);
        if (dialog.open() != 0) {
            return null;
        }
        String diagramName = dialog.getValue();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet);
        if (editingDomain == null) {
            editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)resourceSet);
        }
        AddAllClassesCommand operation = new AddAllClassesCommand(project, editingDomain, diagramName);
        editingDomain.getCommandStack().execute((Command)operation);
        try {
            operation.getCreatedResource().save(null);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.graphiti.examples.tutorial", e.getMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CreateDiagramWithAllClassesHandler_ErrorTitle, (String)e.getMessage(), (IStatus)status);
            return null;
        }
        editingDomain.dispose();
        String platformString = operation.getCreatedResource().getURI().toPlatformString(true);
        IFile file = project.getParent().getFile((IPath)new Path(platformString));
        FileEditorInput input = new FileEditorInput(file);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "org.eclipse.graphiti.ui.editor.DiagramEditor");
        }
        catch (PartInitException e) {
            Status status = new Status(4, "org.eclipse.graphiti.examples.tutorial", e.getMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CreateDiagramWithAllClassesHandler_ErrorTitle, (String)e.getMessage(), (IStatus)status);
            return null;
        }
        return null;
    }
}

