/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class StandardDiagramServices {
    private static final RGB DOMAIN_CLASS_FIELD_COLOR = new RGB(204, 242, 166);
    private static final RGB INTERPRETED_EXPRESSION_FIELD_COLOR = new RGB(255, 245, 181);
    private Color domainClassFieldColor;
    private Color interpretedExpressionFieldColor;

    public List<DSemanticDecorator> stdGetViewsWithSameMapping(DSemanticDiagram currentDiagram, List<DSemanticDecorator> selectedViews) {
        ArrayList<DSemanticDecorator> result = new ArrayList<DSemanticDecorator>();
        HashSet<DiagramElementMapping> mappingsToSelect = new HashSet<DiagramElementMapping>();
        for (DSemanticDecorator dSemanticDecorator : selectedViews) {
            if (!(dSemanticDecorator instanceof DDiagramElement)) continue;
            mappingsToSelect.add(((DDiagramElement)dSemanticDecorator).getDiagramElementMapping());
        }
        for (DDiagramElement dde : new DDiagramQuery((DDiagram)currentDiagram).getAllDiagramElements()) {
            if (!mappingsToSelect.contains(dde.getDiagramElementMapping())) continue;
            result.add((DSemanticDecorator)dde);
        }
        return result;
    }

    public List<DSemanticDecorator> stdGetViewsRepresentingSameEType(DSemanticDiagram currentDiagram, List<DSemanticDecorator> selectedViews) {
        ArrayList<DSemanticDecorator> result = new ArrayList<DSemanticDecorator>();
        HashSet<EClass> eClassToSelect = new HashSet<EClass>();
        for (DSemanticDecorator dSemanticDecorator : selectedViews) {
            if (!(dSemanticDecorator instanceof DDiagramElement)) continue;
            eClassToSelect.add(((DDiagramElement)dSemanticDecorator).getTarget().eClass());
        }
        for (DDiagramElement dde : new DDiagramQuery((DDiagram)currentDiagram).getAllDiagramElements()) {
            if (!eClassToSelect.contains(dde.getTarget().eClass())) continue;
            result.add((DSemanticDecorator)dde);
        }
        return result;
    }

    public List<DSemanticDecorator> stdGetViewsRepresentingSelectedType(DSemanticDiagram currentDiagram) {
        Optional optionalSession;
        ArrayList<DSemanticDecorator> result = new ArrayList<DSemanticDecorator>();
        InputDialog domainClassDialog = new InputDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.StandardDiagramServices_sameETypeTitle, Messages.StandardDiagramServices_sameETypeMessage, "", null){

            protected Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                this.getText().setBackground(StandardDiagramServices.this.getDomainClassFieldColor(this.getShell().getDisplay()));
                this.getText().setToolTipText(Messages.StandardDiagramServices_sameETypeTooltip);
                return control;
            }
        };
        if (domainClassDialog.open() == 0 && (optionalSession = Session.of((EObject)currentDiagram)).isPresent()) {
            String typeName = domainClassDialog.getValue();
            ModelAccessor modelAccessor = ((Session)optionalSession.get()).getModelAccessor();
            for (DDiagramElement dde : new DDiagramQuery((DDiagram)currentDiagram).getAllDiagramElements()) {
                if (!modelAccessor.eInstanceOf(dde.getTarget(), typeName.trim())) continue;
                result.add((DSemanticDecorator)dde);
            }
        }
        return result;
    }

    public List<DSemanticDecorator> stdGetViewsOfExpression(DSemanticDiagram currentDiagram) {
        InputDialog expressionDialog;
        ArrayList<DSemanticDecorator> result = new ArrayList<DSemanticDecorator>();
        Optional optionalSession = Session.of((EObject)currentDiagram);
        if (optionalSession.isPresent() && (expressionDialog = new InputDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.StandardDiagramServices_expressionTitle, Messages.StandardDiagramServices_expressionMessage, "", null){

            protected Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                this.getText().setBackground(StandardDiagramServices.this.getInterpretedExpressionFieldColor(this.getShell().getDisplay()));
                this.getText().setToolTipText(Messages.StandardDiagramServices_expressionTooltip);
                return control;
            }
        }).open() == 0) {
            String expression = expressionDialog.getValue();
            try {
                Collection expressionResult = ((Session)optionalSession.get()).getInterpreter().evaluateCollection((EObject)currentDiagram, expression);
                for (EObject eObject : expressionResult) {
                    if (!(eObject instanceof DDiagramElement)) continue;
                    result.add((DSemanticDecorator)((DDiagramElement)eObject));
                }
            }
            catch (EvaluationException evaluationException) {}
        }
        return result;
    }

    private Color getDomainClassFieldColor(Display display) {
        if (this.domainClassFieldColor == null) {
            this.domainClassFieldColor = new Color((Device)display, DOMAIN_CLASS_FIELD_COLOR);
        }
        return this.domainClassFieldColor;
    }

    private Color getInterpretedExpressionFieldColor(Display display) {
        if (this.interpretedExpressionFieldColor == null) {
            this.interpretedExpressionFieldColor = new Color((Device)display, INTERPRETED_EXPRESSION_FIELD_COLOR);
        }
        return this.interpretedExpressionFieldColor;
    }
}

