/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class QualifiedName {
    public static final String separator = "::";
    private ArrayList<String> segments;

    public QualifiedName(String fqn, String separator) {
        this(fqn.split(separator));
    }

    public QualifiedName(String fqn) {
        this(fqn, separator);
    }

    public QualifiedName(String[] segments) {
        this.segments = new ArrayList(segments.length);
        int i = 0;
        while (i < segments.length) {
            this.append(segments[i]);
            ++i;
        }
    }

    public QualifiedName(Collection<String> segments) {
        this.segments = new ArrayList<String>(segments);
    }

    public QualifiedName(QualifiedName old) {
        this.segments = new ArrayList<String>(old.getSegments());
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public String[] getSegmentsArray() {
        return (String[])this.segments.toArray();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QualifiedName)) {
            return false;
        }
        if (((QualifiedName)obj).segments.size() != this.segments.size()) {
            return false;
        }
        int i = 0;
        while (i < this.segments.size()) {
            if (this.segments.get(i).compareTo(((QualifiedName)obj).segments.get(i)) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String res = "";
        Iterator<String> iter = this.segments.iterator();
        while (iter.hasNext()) {
            res = String.valueOf(res) + iter.next();
            if (!iter.hasNext()) continue;
            res = String.valueOf(res) + separator;
        }
        return res;
    }

    public QualifiedName append(QualifiedName qualifiedName) {
        this.getSegments().addAll(qualifiedName.getSegments());
        return this;
    }

    public QualifiedName append(String name) {
        this.getSegments().add(name);
        return this;
    }
}

