/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime;

import fr.inria.aoste.timesquare.ccslkernel.runtime.AbstractRuntimeBlock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.INamedElement;
import fr.inria.aoste.timesquare.ccslkernel.runtime.IRuntimeContainer;
import fr.inria.aoste.timesquare.ccslkernel.runtime.QualifiedName;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.relations.AbstractRuntimeRelation;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRuntimeModel
implements IRuntimeContainer,
INamedElement {
    private String name;
    private IRuntimeContainer parent = null;

    public AbstractRuntimeModel(String name) {
        this.name = name;
        this.setParent(null);
    }

    public AbstractRuntimeModel(String name, IRuntimeContainer parent) {
        this.name = name;
        this.setParent(parent);
    }

    public abstract AbstractRuntimeBlock[] getSubBlocks();

    public abstract AbstractRuntimeBlock getEntryBlock();

    public abstract AbstractRuntimeModel[] getImportedModels();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IRuntimeContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IRuntimeContainer parent) {
        this.parent = parent;
    }

    @Override
    public void addContent(IRuntimeContainer element) {
    }

    @Override
    public List<IRuntimeContainer> getContents() {
        ArrayList<IRuntimeContainer> res = new ArrayList<IRuntimeContainer>();
        AbstractRuntimeBlock[] abstractRuntimeBlockArray = this.getSubBlocks();
        int n = abstractRuntimeBlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractRuntimeBlock block = abstractRuntimeBlockArray[n2];
            res.add(block);
            ++n2;
        }
        return res;
    }

    @Override
    public void setQualifiedName(QualifiedName qualifiedName) {
    }

    @Override
    public void setQualifiedName(String qualifiedName) {
    }

    @Override
    public QualifiedName getQualifiedName() {
        return new QualifiedName(this.getName());
    }

    public List<RuntimeClock> getAllDiscreteClocks() {
        ArrayList<RuntimeClock> res = new ArrayList<RuntimeClock>();
        AbstractRuntimeModel[] abstractRuntimeModelArray = this.getImportedModels();
        int n = abstractRuntimeModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractRuntimeModel imported = abstractRuntimeModelArray[n2];
            res.addAll(imported.getAllDiscreteClocks());
            ++n2;
        }
        this.getEntryBlock().getAllDiscreteClocks(res);
        return res;
    }

    public List<AbstractRuntimeRelation> getAllAssertions() {
        ArrayList<AbstractRuntimeRelation> res = new ArrayList<AbstractRuntimeRelation>();
        AbstractRuntimeModel[] abstractRuntimeModelArray = this.getImportedModels();
        int n = abstractRuntimeModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractRuntimeModel imported = abstractRuntimeModelArray[n2];
            res.addAll(imported.getAllAssertions());
            ++n2;
        }
        res.addAll(this.getEntryBlock().getAllAssertions());
        return res;
    }

    public void initSimulation(AbstractSemanticHelper helper) throws SimulationException {
        this.getEntryBlock().start(helper);
        AbstractRuntimeModel[] abstractRuntimeModelArray = this.getImportedModels();
        int n = abstractRuntimeModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractRuntimeModel imported = abstractRuntimeModelArray[n2];
            imported.initSimulation(helper);
            ++n2;
        }
    }

    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        this.getEntryBlock().semantic(helper);
        AbstractRuntimeModel[] abstractRuntimeModelArray = this.getImportedModels();
        int n = abstractRuntimeModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractRuntimeModel imported = abstractRuntimeModelArray[n2];
            imported.semantic(helper);
            ++n2;
        }
    }

    public void update(AbstractUpdateHelper helper) throws SimulationException {
        this.getEntryBlock().update(helper);
        AbstractRuntimeModel[] abstractRuntimeModelArray = this.getImportedModels();
        int n = abstractRuntimeModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractRuntimeModel imported = abstractRuntimeModelArray[n2];
            imported.update(helper);
            ++n2;
        }
    }

    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        this.getEntryBlock().deathSemantic(helper);
        AbstractRuntimeModel[] abstractRuntimeModelArray = this.getImportedModels();
        int n = abstractRuntimeModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractRuntimeModel imported = abstractRuntimeModelArray[n2];
            imported.deathSemantic(helper);
            ++n2;
        }
    }
}

