/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.provider.DiagramItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DEdgeBeginLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DEdgeEndLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DEdgeLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DNodeLabelItemProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePageListener;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline.OutlineContentResourceSetListener;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;

public class OutlineContentProvider
implements ITreeContentProvider,
DiagramOutlinePageListener {
    OutlineContentResourceSetListener outlineContentResourceSetListener = new OutlineContentResourceSetListener();

    private boolean checkParent(EObject parent) {
        boolean check = false;
        if (parent == null) {
            check = true;
        } else if (parent instanceof DDiagram) {
            check = true;
        } else if (parent instanceof DDiagramElementContainer) {
            check = true;
        }
        return check;
    }

    private DDiagram getDiagramContainer(EObject element) {
        DDiagram dia = null;
        if (element instanceof DDiagram) {
            dia = (DDiagram)element;
        } else if (element != null) {
            dia = this.getDiagramContainer(element.eContainer());
        }
        return dia;
    }

    private List<Object> clearFilteredElements(List<? extends Object> elements, DDiagram vp) {
        Session session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)vp).getTarget());
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, vp);
        ArrayList<Object> result = new ArrayList<Object>(elements.size());
        for (Object object : elements) {
            Option<DDiagramElement> optionTarget;
            if (object instanceof DDiagramElement) {
                DDiagramElement dde = (DDiagramElement)object;
                if (this.isFiltered(mappingManager, dde)) continue;
                result.add(dde);
                continue;
            }
            if (!(object instanceof AbstractDDiagramElementLabelItemProvider) || !(optionTarget = ((AbstractDDiagramElementLabelItemProvider)((Object)object)).getDiagramElementTarget()).some() || this.isFiltered(mappingManager, (DDiagramElement)optionTarget.get())) continue;
            result.add(object);
        }
        return result;
    }

    private boolean isFiltered(DiagramMappingsManager session, DDiagramElement dde) {
        boolean isFiltered = true;
        if (dde.isVisible()) {
            isFiltered = false;
        } else if (LayerHelper.isInActivatedLayer((DiagramMappingsManager)session, (DDiagramElement)dde) && !new DDiagramElementQuery(dde).isFiltered()) {
            isFiltered = false;
        }
        return isFiltered;
    }

    public Object getParent(Object element) {
        DDiagramElement vpe;
        EObject parent;
        EObject theParent = null;
        if (element instanceof DDiagram) {
            return theParent;
        }
        if (element instanceof DNode) {
            DNode vn = (DNode)element;
            EObject parent2 = vn.eContainer();
            if (parent2 instanceof DNode) {
                theParent = parent2;
            } else if (this.checkParent(parent2)) {
                theParent = parent2;
            }
        } else if (element instanceof DDiagramElement && this.checkParent(parent = (vpe = (DDiagramElement)element).eContainer())) {
            theParent = parent;
        }
        return theParent;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        if (parentElement instanceof DDiagram) {
            DDiagram diagram = (DDiagram)parentElement;
            children = this.clearFilteredElements((List<? extends Object>)diagram.getOwnedDiagramElements(), diagram).toArray();
        } else if (parentElement instanceof DNode) {
            DNode dNode = (DNode)parentElement;
            ArrayList<DNodeLabelItemProvider> originalChildren = new ArrayList<DNodeLabelItemProvider>((Collection<DNodeLabelItemProvider>)dNode.getOwnedBorderedNodes());
            if (DNodeLabelItemProvider.hasRelevantLabelItem((DDiagramElement)dNode)) {
                originalChildren.add(0, new DNodeLabelItemProvider(this.getAdapterFactory(), dNode));
            }
            children = this.clearFilteredElements(originalChildren, this.getDiagramContainer((EObject)dNode)).toArray();
        } else if (parentElement instanceof DEdge) {
            DEdge dEdge = (DEdge)parentElement;
            ArrayList<AbstractDDiagramElementLabelItemProvider> originalChildren = new ArrayList<AbstractDDiagramElementLabelItemProvider>();
            if (DEdgeBeginLabelItemProvider.hasRelevantLabelItem((DDiagramElement)dEdge)) {
                originalChildren.add(0, new DEdgeBeginLabelItemProvider(this.getAdapterFactory(), dEdge));
            }
            if (DEdgeLabelItemProvider.hasRelevantLabelItem((DDiagramElement)dEdge)) {
                originalChildren.add(0, new DEdgeLabelItemProvider(this.getAdapterFactory(), dEdge));
            }
            if (DEdgeEndLabelItemProvider.hasRelevantLabelItem((DDiagramElement)dEdge)) {
                originalChildren.add(0, new DEdgeEndLabelItemProvider(this.getAdapterFactory(), dEdge));
            }
            children = this.clearFilteredElements(originalChildren, this.getDiagramContainer((EObject)dEdge)).toArray();
        } else if (parentElement instanceof DDiagramElementContainer) {
            DDiagramElementContainer diagramElementContainer = (DDiagramElementContainer)parentElement;
            children = this.clearFilteredElements((List<? extends Object>)diagramElementContainer.getElements(), this.getDiagramContainer((EObject)diagramElementContainer)).toArray();
        }
        return children;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (element instanceof DDiagram || element instanceof DNode || element instanceof DEdge || element instanceof DDiagramElementContainer) {
            hasChildren = this.getChildren(element).length > 0;
        }
        return hasChildren;
    }

    public Object[] getElements(Object inputElement) {
        Diagram diagram;
        EObject viewpointDiagram;
        if (inputElement instanceof Diagram && (viewpointDiagram = (diagram = (Diagram)inputElement).getElement()) != null) {
            return new Object[]{viewpointDiagram};
        }
        return new Object[]{inputElement};
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (!(oldInput == null || oldInput instanceof EObject && ((EObject)oldInput).eResource() == null)) {
            this.removeListenerFrom((View)oldInput);
        }
        if (newInput != null) {
            this.outlineContentResourceSetListener.setViewer(viewer);
            this.addListenerTo((View)newInput);
        }
    }

    private void removeListenerFrom(View oldInput) {
        DDiagram diagram;
        TransactionalEditingDomain domain;
        EObject element = oldInput.getElement();
        if (element instanceof DDiagram && (domain = TransactionUtil.getEditingDomain((EObject)(diagram = (DDiagram)element))) != null) {
            domain.removeResourceSetListener((ResourceSetListener)this.outlineContentResourceSetListener);
        }
    }

    private void addListenerTo(View newInput) {
        DDiagram diagram;
        TransactionalEditingDomain domain;
        EObject element = newInput.getElement();
        if (element instanceof DDiagram && (domain = TransactionUtil.getEditingDomain((EObject)(diagram = (DDiagram)element))) != null) {
            domain.addResourceSetListener((ResourceSetListener)this.outlineContentResourceSetListener);
        }
    }

    @Override
    public void activate(int page) {
        this.outlineContentResourceSetListener.activate(page);
    }

    @Override
    public void deactivate(int page) {
        this.outlineContentResourceSetListener.deactivate(page);
    }

    public AdapterFactory getAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ViewpointItemProviderAdapterFactory());
        factories.add((Object)new DiagramItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }
}

