/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.properties.descriptors;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.ui.services.properties.descriptors.ICompositeSourcePropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CompositeSourcePropertyDescriptor
extends PropertyDescriptor
implements ICompositeSourcePropertyDescriptor {
    private Object object = null;
    private boolean readOnly = false;
    private CellEditor propertyEditor = null;
    private Object propertyValue = null;
    private Object defaultValue = null;

    public CompositeSourcePropertyDescriptor(Object object, Object id, String displayName) {
        super(id, displayName);
        this.object = object;
    }

    protected Object getObject() {
        return this.object;
    }

    public CellEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void addFilterFlag(String flag) {
        assert (flag != null) : "flag cannot be null";
        List<String> flags = Arrays.asList(this.getFilterFlags());
        if (!flags.contains(flag)) {
            int total = flags.size();
            String[] newFlags = new String[total];
            System.arraycopy(this.getFilterFlags(), 0, newFlags, 0, total);
            newFlags[total - 1] = flag;
            this.setFilterFlags(newFlags);
        }
    }

    @Override
    public Object getPropertyValue() {
        Object aValue = this.getEditableValue();
        IPropertySource source = this.getPropertySource(aValue);
        if (source != null) {
            aValue = source.getEditableValue();
        }
        return aValue;
    }

    @Override
    public void resetPropertyValue() {
        if (this.getDefaultValue() != null) {
            this.setPropertyValue(this.getDefaultValue());
        }
    }

    @Override
    public void setPropertyValue(Object value) {
        if (value == null) {
            return;
        }
        Object oldValue = this.getEditableValue();
        if (oldValue != null && oldValue.equals(value) || oldValue == null && value == null) {
            return;
        }
        this.setValue(value);
    }

    protected void setValue(Object value) {
        this.propertyValue = value;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (this.isReadOnly()) {
            return null;
        }
        if (this.getPropertyEditor() != null) {
            if (this.getPropertyEditor().getControl() == null) {
                this.getPropertyEditor().create(parent);
            }
            return this.getPropertyEditor();
        }
        return null;
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        if (this == anotherProperty) {
            return true;
        }
        if (!this.getClass().isInstance(anotherProperty)) {
            return false;
        }
        return this.getCategory().equals(anotherProperty.getCategory()) && this.getId().equals(anotherProperty.getId());
    }

    public void setPropertyEditor(CellEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    protected Object getEditableValue() {
        return this.propertyValue;
    }

    protected IPropertySource getPropertySource(Object value) {
        return value == null ? null : (IPropertySource)Platform.getAdapterManager().getAdapter(value, IPropertySource.class);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void resetPropertyValue(Object value) {
        this.setPropertyValue(this.getDefaultValue());
    }
}

