/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.messagingsystem.api.impl;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.Request;

public class Server4MessagingSystem
implements Runnable {
    int port;
    MessagingSystem logger;
    ServerSocket serverSocket;

    public Server4MessagingSystem(int port, MessagingSystem ms) {
        try {
            this.logger = ms;
            this.serverSocket = new ServerSocket(port);
            this.port = this.serverSocket.getLocalPort();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), Server4MessagingSystem.class.getName(), e);
        }
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        ObjectInputStream reader = null;
        try {
            Socket clientSocket = this.serverSocket.accept();
            InputStream in = clientSocket.getInputStream();
            reader = new ObjectInputStream(new BufferedInputStream(in));
            this.logger.log(MessagingSystem.Kind.DevINFO, "Messaging system server started on port " + this.port, "");
            block14: while (true) {
                Object msg = reader.readObject();
                Request req = (Request)msg;
                switch (req.calledMethod) {
                    case clearLog: {
                        this.logger.clearLog();
                        continue block14;
                    }
                    case log: {
                        this.logger.log(req.msgKind, req.message, req.messageGroup);
                        continue block14;
                    }
                    case logProblem: {
                        continue block14;
                    }
                    case initProgress: {
                        this.logger.initProgress(req.progressGroup, req.message, req.messageGroup, req.nbUnit);
                        continue block14;
                    }
                    case progress: {
                        this.logger.progress(req.progressGroup, req.message, req.messageGroup, req.nbUnit);
                        continue block14;
                    }
                    case doneProgress: {
                        this.logger.doneProgress(req.progressGroup, req.message, req.messageGroup);
                        continue block14;
                    }
                }
            }
        }
        catch (EOFException eOFException) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                this.logger.error(e1.getMessage(), Server4MessagingSystem.class.getName(), e1);
            }
        }
        catch (SocketException e) {
            if ("Connection reset".equals(e.getMessage())) {
                this.logger.log(MessagingSystem.Kind.DevDEBUG, String.valueOf(e.getMessage()) + " on sockect port " + this.port, Server4MessagingSystem.class.getName(), null);
            } else {
                this.logger.log(MessagingSystem.Kind.DevDEBUG, e.getMessage(), Server4MessagingSystem.class.getName(), e);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), Server4MessagingSystem.class.getName(), e);
        }
    }
}

