/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.launch;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.generator.base.io.ILineOutput;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.shared.SharedStateModule;

class ConsoleOutput
implements ILineOutput {
    @Inject
    private IURIEditorOpener uriEditorOpener;
    private MessageConsoleStream stream;

    public ConsoleOutput(MessageConsoleStream stream) {
        this.stream = stream;
        Injector injector = Guice.createInjector((Module[])new Module[]{new SharedStateModule()});
        this.uriEditorOpener = (IURIEditorOpener)injector.getInstance(IURIEditorOpener.class);
        stream.getConsole().addPatternMatchListener((IPatternMatchListener)new URIHyperlinkSetter());
    }

    public void println(String txt) {
        this.stream.println(txt);
    }

    private class URIHyperlinkSetter
    implements IPatternMatchListener {
        private static final int URI_GROUP = 1;
        private static final int LINE_NUMBER_GROUP = 4;
        private static final String LINE_REGEX = "line\\s?:\\s?(\\d+)";
        private static final String URI_REGEX = "(resource|platform|file):/[^\\s\\(\\)\\[\\]]+";
        private static final String HYPERLINK_REGEX = "((resource|platform|file):/[^\\s\\(\\)\\[\\]]+)(\\sline\\s?:\\s?(\\d+))?";
        private Pattern hyperlinkPattern = Pattern.compile("((resource|platform|file):/[^\\s\\(\\)\\[\\]]+)(\\sline\\s?:\\s?(\\d+))?");

        private URIHyperlinkSetter() {
        }

        public void connect(TextConsole console) {
        }

        public void disconnect() {
        }

        public void matchFound(PatternMatchEvent event) {
            try {
                String match = ConsoleOutput.this.stream.getConsole().getDocument().get(event.getOffset(), event.getLength());
                Matcher lineMatcher = this.hyperlinkPattern.matcher(match);
                if (!lineMatcher.matches()) {
                    return;
                }
                URI uri = URI.createURI((String)lineMatcher.group(1), (boolean)true);
                if (uri == null || uri.fileExtension() == null) {
                    return;
                }
                String lineNumber = lineMatcher.group(4);
                ConsoleOutput.this.stream.getConsole().addHyperlink((IHyperlink)new XtextLink(uri, lineNumber), event.getOffset(), event.getLength());
            }
            catch (Throwable throwable) {}
        }

        public String getPattern() {
            return HYPERLINK_REGEX;
        }

        public int getCompilerFlags() {
            return 0;
        }

        public String getLineQualifier() {
            return null;
        }
    }

    private class XtextLink
    implements IHyperlink {
        private URI uri;
        private String lineNumber;

        public XtextLink(URI uri, String lineNumber) {
            this.uri = uri;
            this.lineNumber = lineNumber;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            IEditorPart editor;
            int line = -1;
            if (this.lineNumber != null && !this.uri.hasFragment()) {
                try {
                    line = Integer.parseInt(this.lineNumber);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((editor = ConsoleOutput.this.uriEditorOpener.open(this.uri, true)) instanceof ITextEditor && line > 0) {
                ITextEditor textEditor = (ITextEditor)editor;
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                if (document == null) {
                    return;
                }
                try {
                    int lineOffset = document.getLineOffset(line - 1);
                    textEditor.selectAndReveal(lineOffset, 0);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }
}

