/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public abstract class MultiValidator2
extends MultiValidator {
    private int targetCount;
    private DataBindingContext bindingContext;
    private List<IObservableValue> targets;
    private IObservableList converterStatusProviders;
    private IObservableValue converterStatusObservable;

    public MultiValidator2(DataBindingContext bindingContext, int values) {
        this.bindingContext = bindingContext;
        this.targetCount = values;
        this.converterStatusProviders = new WritableList(new ArrayList(this.targetCount), ValidationStatusProvider.class);
        this.converterStatusObservable = new AggregateValidationStatus((IObservableCollection)this.converterStatusProviders, 2);
        this.targets = new ArrayList<IObservableValue>(this.targetCount);
        bindingContext.addValidationStatusProvider((ValidationStatusProvider)this);
    }

    protected final IStatus validate() {
        ArrayList<Object> values = new ArrayList<Object>(this.targetCount);
        for (IObservableValue observable : this.targets) {
            values.add(observable.getValue());
        }
        IStatus converterStatus = (IStatus)this.converterStatusObservable.getValue();
        if (!converterStatus.isOK()) {
            return ValidationStatus.error((String)"");
        }
        if (this.targetCount != this.targets.size()) {
            return ValidationStatus.ok();
        }
        return this.validate(values);
    }

    public abstract IStatus validate(List<Object> var1);

    public void installValidator(Binding targetToMiddle, IObservableValue model) {
        IObservableValue target = (IObservableValue)targetToMiddle.getModel();
        this.targets.add(target);
        IObservableValue validatedObservable = this.observeValidatedValue(target);
        this.bindingContext.bindValue(validatedObservable, model);
        this.converterStatusProviders.add((Object)targetToMiddle);
    }
}

