/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public class DiagnosingModelObserver
extends EContentAdapter {
    private HashMap<EObject, ArrayList<Diagnostic>> elementDiagnosticMap = new HashMap();
    private EObject mdel;
    private boolean enabled;

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void observeModel(EObject model) {
        this.mdel = model;
        this.setTarget(model);
        this.enable();
        this.updateElementDiagnosticMap();
    }

    public void removeObserver() {
        this.disable();
        this.elementDiagnosticMap.clear();
        if (this.mdel != null) {
            this.unsetTarget(this.mdel);
            this.mdel = null;
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getEventType() < 8 && notification.getNewValue() instanceof EObject && !(notification.getNewValue() instanceof DetailCode)) {
            this.updateElementDiagnosticMap();
        }
    }

    public HashMap<EObject, ArrayList<Diagnostic>> getElementDiagonsticMap() {
        return this.elementDiagnosticMap;
    }

    private void updateElementDiagnosticMap() {
        if (!this.isEnabled()) {
            return;
        }
        this.elementDiagnosticMap.clear();
        Diagnostic diagnostics = Diagnostician.INSTANCE.validate(this.mdel);
        HashMap uniqueEnsurer = new HashMap();
        uniqueEnsurer.clear();
        for (Diagnostic diagnostic : diagnostics.getChildren()) {
            if (!(diagnostic instanceof FeatureBasedDiagnostic)) continue;
            FeatureBasedDiagnostic featureBasedDiagnostic = (FeatureBasedDiagnostic)diagnostic;
            EObject source = featureBasedDiagnostic.getSourceEObject();
            EObject eObject = null;
            if (source instanceof StateGraph) {
                EStructuralFeature feature = featureBasedDiagnostic.getFeature();
                int index = featureBasedDiagnostic.getIndex();
                if (!feature.isMany()) {
                    eObject = (EObject)source.eGet(feature);
                } else if (index != -1) {
                    List list = (List)source.eGet(feature);
                    eObject = (EObject)list.get(index);
                }
            } else {
                eObject = source instanceof Trigger ? source.eContainer() : source;
            }
            if (eObject == null) continue;
            if (this.elementDiagnosticMap.get(eObject) == null) {
                this.elementDiagnosticMap.put(eObject, new ArrayList());
                uniqueEnsurer.put(eObject, new HashSet());
            }
            String certificate = featureBasedDiagnostic.getIssueCode();
            String[] stringArray = featureBasedDiagnostic.getIssueData();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String data = stringArray[n2];
                certificate = String.valueOf(certificate) + data;
                ++n2;
            }
            if (((HashSet)uniqueEnsurer.get(eObject)).contains(certificate)) continue;
            ((HashSet)uniqueEnsurer.get(eObject)).add(certificate);
            this.elementDiagnosticMap.get(eObject).add(diagnostic);
        }
    }
}

