/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base.io;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.generator.base.GeneratorException;
import org.eclipse.etrice.generator.base.args.Arguments;
import org.eclipse.etrice.generator.base.io.FileSystemModelPath;
import org.eclipse.etrice.generator.base.io.IGeneratorEMFSetup;
import org.eclipse.etrice.generator.base.io.IGeneratorResourceLoader;
import org.eclipse.etrice.generator.base.io.IModelPath;
import org.eclipse.etrice.generator.base.io.NIOPathUtil;
import org.eclipse.etrice.generator.base.io.ResourceSetModelPathProvider;
import org.eclipse.etrice.generator.base.logging.ILogger;

public class GeneratorResourceLoader
implements IGeneratorResourceLoader {
    private Provider<ResourceSet> resourceSetProvider;
    private IGeneratorEMFSetup emfSetup;
    private boolean initializedEMF;

    @Inject
    public GeneratorResourceLoader(Provider<ResourceSet> resourceSetProvider, IGeneratorEMFSetup emfSetup) {
        this.resourceSetProvider = resourceSetProvider;
        this.emfSetup = emfSetup;
        this.initializedEMF = EMFPlugin.IS_ECLIPSE_RUNNING;
    }

    @Override
    public List<Resource> load(List<String> files, List<String> modelpath, Arguments arguments, ILogger logger) throws GeneratorException {
        this.doEMFRegistration();
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        ResourceAddedAdapter resourceAddedAdapter = new ResourceAddedAdapter(logger);
        resourceSet.eAdapters().add((Object)resourceAddedAdapter);
        IModelPath mp = this.createModelPath(modelpath, logger);
        ResourceSetModelPathProvider.install(resourceSet, mp);
        List<Resource> resources = this.loadResources(files, resourceSet, logger);
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        return resources;
    }

    private void doEMFRegistration() {
        if (!this.initializedEMF) {
            this.emfSetup.doEMFRegistration();
            this.initializedEMF = true;
        }
    }

    private List<Resource> loadResources(List<String> files, ResourceSet resourceSet, ILogger logger) {
        ArrayList<Resource> resources = new ArrayList<Resource>(files.size());
        for (String f : files) {
            Resource r = this.loadResource(f, resourceSet, logger);
            resources.add(r);
        }
        return resources;
    }

    private Resource loadResource(String file, ResourceSet rs, ILogger logger) {
        Path path = Paths.get(file, new String[0]).normalize();
        if (Files.exists(path, new LinkOption[0])) {
            Path realPath = this.toRealPath(path, new LinkOption[0]);
            URI uri = NIOPathUtil.toEMFUri(realPath);
            try {
                return rs.getResource(uri, true);
            }
            catch (RuntimeException e) {
                logger.logError("could not load file " + file + "; " + e.getMessage());
                throw new GeneratorException(e);
            }
        }
        logger.logError("could not find file " + file);
        throw new GeneratorException();
    }

    private IModelPath createModelPath(List<String> pathStrings, ILogger logger) {
        ArrayList<FileSystemModelPath.ModelDirectory> modelDirs = new ArrayList<FileSystemModelPath.ModelDirectory>(pathStrings.size());
        for (String pathString : pathStrings) {
            Path path = Paths.get(pathString, new String[0]).normalize();
            if (Files.exists(path, new LinkOption[0])) {
                Path realPath = this.toRealPath(path, new LinkOption[0]);
                if (Files.isDirectory(realPath, new LinkOption[0])) {
                    modelDirs.add(new FileSystemModelPath.ModelDirectory(realPath));
                    continue;
                }
                if (!Files.isRegularFile(realPath, new LinkOption[0])) continue;
                FileSystem fileSystem = this.getFileSystem(realPath, logger);
                for (Path rootDir : fileSystem.getRootDirectories()) {
                    modelDirs.add(new FileSystemModelPath.ModelDirectory(rootDir));
                }
                continue;
            }
            logger.logDebug("could not find modelpath entry " + pathString);
        }
        modelDirs.forEach(this::indexDirectory);
        return new FileSystemModelPath(modelDirs);
    }

    private void indexDirectory(FileSystemModelPath.ModelDirectory modelDir) {
        try {
            modelDir.indexDirectory();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private FileSystem getFileSystem(Path path, ILogger logger) {
        try {
            return FileSystems.newFileSystem(path, null);
        }
        catch (ProviderNotFoundException e) {
            logger.logError("could not read modelpath entry " + path.toString());
            throw new GeneratorException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path toRealPath(Path path, LinkOption ... options) {
        try {
            return path.toRealPath(options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class ResourceAddedAdapter
    extends AdapterImpl {
        private ILogger logger;

        public ResourceAddedAdapter(ILogger logger) {
            this.logger = logger;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() == 3) {
                Resource addedResource = (Resource)msg.getNewValue();
                this.logger.logDebug("added resource " + addedResource.getURI());
            }
        }
    }
}

