/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.dctools.fsm.ast.nodes;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.dctools.fsm.ast.util.IDCAstNodeVisitor;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public abstract class DCAstNode {
    private DCAstNode parent;
    private int readTokens;
    private List<DCAstNode> children = CollectionLiterals.newArrayList();
    private EObject linkedObject;
    private Object linkedData;

    public DCAstNode() {
        this(null, 0);
    }

    public DCAstNode(DCAstNode parent, int readTokens) {
        this.parent = parent;
        this.readTokens = readTokens;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public DCAstNode c(int i) {
        return this.children.get(i);
    }

    public void setParent(DCAstNode parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        if (parent != null) {
            this.parent.children.add(this);
        }
    }

    public int totallyReadTokens() {
        int sum = this.readTokens;
        for (DCAstNode child : this.children) {
            int n = sum;
            int n2 = child.totallyReadTokens();
            sum = n + n2;
        }
        return sum;
    }

    public void print() {
        this.printRecursive("");
    }

    public void visit(IDCAstNodeVisitor visitor) {
        boolean descend = visitor.visitBegin(this);
        if (descend) {
            for (DCAstNode child : this.children) {
                child.visit(visitor);
            }
        }
        visitor.visitEnd(this);
    }

    protected void printRecursive(String indent) {
        this.doPrint(indent);
        for (DCAstNode child : this.children) {
            child.printRecursive(String.valueOf(indent) + "  ");
        }
    }

    protected String getLinkedObjectText() {
        String string = null;
        if (this.linkedObject != null) {
            String string2 = this.linkedObject.eClass().getName();
            return " --> " + string2;
        }
        string = "";
        return string;
    }

    protected abstract void doPrint(String var1);

    @Pure
    public DCAstNode getParent() {
        return this.parent;
    }

    @Pure
    public int getReadTokens() {
        return this.readTokens;
    }

    public void setReadTokens(int readTokens) {
        this.readTokens = readTokens;
    }

    @Pure
    public List<DCAstNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<DCAstNode> children) {
        this.children = children;
    }

    @Pure
    public EObject getLinkedObject() {
        return this.linkedObject;
    }

    public void setLinkedObject(EObject linkedObject) {
        this.linkedObject = linkedObject;
    }

    @Pure
    public Object getLinkedData() {
        return this.linkedData;
    }

    public void setLinkedData(Object linkedData) {
        this.linkedData = linkedData;
    }
}

