/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.merger;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.PrintFileIntoDecls;
import org.eclipse.escet.cif.cif2cif.SvgFileIntoDecls;
import org.eclipse.escet.cif.common.CifRelativePathUtils;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.merger.CifMerger;
import org.eclipse.escet.cif.merger.MergedSpecIsPartialOption;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.typechecker.postchk.AssignmentPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifAnnotationsPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.cif.typechecker.postchk.CifSvgPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifToolPostCheckEnv;
import org.eclipse.escet.cif.typechecker.postchk.CyclePostChecker;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.FilesOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CifMergerApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifMergerApp app = new CifMergerApp();
        app.run(args, true);
    }

    public CifMergerApp() {
    }

    public CifMergerApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF merger";
    }

    public String getAppDescription() {
        return "Merges CIF specifications together into a single CIF specification.";
    }

    /*
     * Unable to fully structure code
     */
    protected int runInternal() {
        mergedPaths = Lists.list();
        todoPaths = new LinkedList<E>(FilesOption.getPaths());
        mergedSpec = null;
        mergedAbsDirPath = null;
        while (!todoPaths.isEmpty()) {
            block13: {
                curFilePath = (String)todoPaths.pollFirst();
                absFilePath = Paths.resolve((String)curFilePath);
                absDirPath = Paths.getAbsFilePathDir((String)absFilePath);
                reader = new CifReader();
                reader.init(curFilePath, absFilePath, false);
                curSpec = (Specification)reader.read();
                if (this.isTerminationRequested()) {
                    return 0;
                }
                new ElimComponentDefInst().transform(curSpec);
                if (this.isTerminationRequested()) {
                    return 0;
                }
                new SvgFileIntoDecls().transform(curSpec);
                new PrintFileIntoDecls().transform(curSpec);
                if (mergedSpec == null) {
                    mergedSpec = curSpec;
                    mergedAbsDirPath = absDirPath;
                } else {
                    CifRelativePathUtils.adaptRelativePaths((ComplexComponent)curSpec, (String)absDirPath, (String)mergedAbsDirPath);
                    try {
                        merger = new CifMerger();
                        mergedSpec = merger.merge(mergedSpec, curSpec, MergedSpecIsPartialOption.isPartial());
                        if (this.isTerminationRequested()) {
                            return 0;
                        }
                        break block13;
                    }
                    catch (UnsupportedException e) {
                        paths = Lists.listc((int)mergedPaths.size());
                        ** for (path : mergedPaths)
                    }
lbl-1000:
                    // 1 sources

                    {
                        paths.add("\"" + path + "\"");
                        continue;
                    }
lbl37:
                    // 1 sources

                    mergedPathsTxt = String.join((CharSequence)", ", paths);
                    msg = Strings.fmt((String)"Merging CIF specification%s %s with CIF specification \"%s\" failed.", (Object[])new Object[]{mergedPaths.size() == 1 ? "" : "s", mergedPathsTxt, curFilePath});
                    throw new UnsupportedException(msg, (Throwable)e);
                }
            }
            mergedPaths.add(curFilePath);
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        env = new CifToolPostCheckEnv(mergedAbsDirPath, "merged");
        try {
            CyclePostChecker.check(mergedSpec, (CifPostCheckEnv)env);
            new CifSvgPostChecker((CifPostCheckEnv)env).check(mergedSpec);
            new AssignmentPostChecker().check(mergedSpec, (CifPostCheckEnv)env);
            new CifAnnotationsPostChecker((CifPostCheckEnv)env).check(mergedSpec);
        }
        catch (SemanticException absFilePath) {
            // empty catch block
        }
        env.throwUnsupportedExceptionIfAnyErrors("Merging CIF specifications failed.");
        outPath = OutputFileOption.getPath();
        if (outPath == null) {
            outPath = "merged.cif";
        }
        absOutPath = Paths.resolve((String)outPath);
        CifWriter.writeCifSpec(mergedSpec, (PathPair)new PathPair(outPath, absOutPath), mergedAbsDirPath);
        return 0;
    }

    protected OutputProvider<IOutputComponent> createProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = CifMergerApp.getGeneralOptionCategory();
        List mergeOpts = Lists.list();
        mergeOpts.add(Options.getInstance(FilesOption.class));
        mergeOpts.add(Options.getInstance(OutputFileOption.class));
        mergeOpts.add(Options.getInstance(MergedSpecIsPartialOption.class));
        List mergeSubCats = Lists.list();
        OptionCategory mergeCat = new OptionCategory("Merger", "Merger options.", mergeSubCats, mergeOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, mergeCat});
        OptionCategory options = new OptionCategory("CIF Merger Options", "All options for the CIF merger.", cats, Lists.list());
        return options;
    }
}

