/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework;

import java.io.File;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.app.framework.AppProperties;
import org.eclipse.escet.common.app.framework.CrashReport;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.management.AppManager;
import org.eclipse.escet.common.app.framework.options.DevModeOption;
import org.eclipse.escet.common.app.framework.options.GuiOption;
import org.eclipse.escet.common.app.framework.options.HelpOption;
import org.eclipse.escet.common.app.framework.options.LicenseOption;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.OptionDialogOption;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputModeOption;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.app.framework.output.StreamOutputComponent;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.eclipse.escet.common.java.exceptions.EndUserException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class Application<T extends IOutputComponent> {
    private final AppEnvData appEnvData;
    private boolean firstException = true;

    public Application() {
        this(null, null, null, null);
    }

    public Application(AppStreams streams) {
        this(streams, null, null, null);
    }

    public Application(AppStreams streams, Options options) {
        this(streams, null, options, null);
    }

    public Application(AppEnvData data) {
        this(data.getStreams(), data.getProvider(), data.getOptions(), data.getProperties());
    }

    public Application(AppStreams streams, OutputProvider<?> provider, Options options, AppProperties properties) {
        this.appEnvData = new AppEnvData(this, streams == null ? new AppStreams() : streams, provider == null ? this.createProvider() : provider, options == null ? new Options() : options, properties == null ? new AppProperties() : properties);
        AppEnv.registerApplication(this.appEnvData);
        Options.set(DevModeOption.class, Boolean.valueOf(false));
        Options.set(OptionDialogOption.class, Boolean.valueOf(false));
    }

    protected abstract OutputProvider<T> createProvider();

    public final int run(String[] args, boolean exit) {
        int exitCode;
        AppManager.add(this, null);
        try {
            exitCode = this.runApplication(args, exit);
        }
        finally {
            AppManager.remove(this);
        }
        return exitCode;
    }

    /*
     * Exception decompiling
     */
    public final int runApplication(String[] args, boolean exit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract int runInternal();

    private int reportEx(Throwable terminationEx) {
        List reportExs = Lists.listc((int)1);
        reportExs.add(terminationEx);
        Application.addSuppresseds(terminationEx, reportExs);
        int exitCode = 0;
        for (Throwable reportEx : reportExs) {
            if (!this.firstException) {
                OutputProvider.err("");
            }
            this.firstException = false;
            if (reportEx instanceof ApplicationException) {
                this.reportAppEx((ApplicationException)reportEx);
                if (exitCode >= 1) continue;
                exitCode = 1;
                continue;
            }
            if (reportEx instanceof OutOfMemoryError) {
                String msg = "The application has run out of memory.";
                this.reportAppEx(new ApplicationException(msg, reportEx));
                if (exitCode >= 2) continue;
                exitCode = 2;
                continue;
            }
            this.reportCrash(reportEx);
            if (exitCode >= 3) continue;
            exitCode = 3;
        }
        return exitCode;
    }

    private static void addSuppresseds(Throwable ex, List<Throwable> exs) {
        LinkedList<Pair> queue = new LinkedList<Pair>();
        queue.add(Pair.pair((Object)ex, (Object)false));
        while (!queue.isEmpty()) {
            Pair item = (Pair)queue.pollFirst();
            Throwable curEx = (Throwable)item.left;
            Boolean suppressed = (Boolean)item.right;
            if (suppressed.booleanValue()) {
                exs.add(curEx);
            }
            Throwable[] suppressions = curEx.getSuppressed();
            int i = suppressions.length - 1;
            while (i >= 0) {
                queue.addFirst(Pair.pair((Object)suppressions[i], (Object)true));
                --i;
            }
            Throwable cause = curEx.getCause();
            if (cause == null) continue;
            queue.addFirst(Pair.pair((Object)cause, (Object)false));
        }
    }

    private void reportAppEx(ApplicationException ex) {
        OutputProvider.err("ERROR: " + ex.getMessage());
        if (ex.getCause() != null) {
            this.reportAppExCause(ex.getCause());
        }
    }

    private void reportAppExCause(Throwable ex) {
        while (ex != null) {
            String exMsg = ex.getMessage();
            if (exMsg == null) {
                exMsg = "<cause details not available>";
            }
            if (ex instanceof EndUserException) {
                OutputProvider.err("CAUSE: %s", exMsg);
            } else {
                OutputProvider.err("CAUSE: (%s) %s", ex.getClass().getSimpleName(), exMsg);
            }
            ex = ex.getCause();
        }
    }

    private void reportCrash(Throwable ex) {
        if (DevModeOption.isEnabled()) {
            AppEnv.getStreams().err.print("CRASH: ");
            AppEnv.getStreams().err.printStackTrace(ex);
            return;
        }
        String crashReportPath = CrashReport.writeCrashReportFile(ex);
        OutputProvider.err("ERROR: The application has crashed. Please always report crashes to the Eclipse ESCET development team.");
        OutputProvider.err("REPORT: A crash report was generated in file \"%s\".", crashReportPath);
        if (Platform.isRunning() && PlatformUI.isWorkbenchRunning()) {
            File crashFile = new File(crashReportPath);
            String parentPath = crashFile.getParent();
            URI parentURI = null;
            try {
                parentURI = Paths.createJavaURI(parentPath);
            }
            catch (RuntimeException e) {
                OutputProvider.err("ERROR: Failed to resolve crash report location for refresh: " + parentPath);
            }
            if (parentURI != null) {
                try {
                    IFile[] parentFiles;
                    IFile[] iFileArray = parentFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(parentURI);
                    int n = parentFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile parentFile = iFileArray[n2];
                        parentFile.getProject().refreshLocal(2, null);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    OutputProvider.err("ERROR: Failed to refresh: " + parentPath);
                }
            }
        }
    }

    public void printHelpMessage(AppStream s) {
        this.printHelpHeader(s);
        s.println();
        this.printHelpOptions(s);
        if (this.getHelpMessageNotes().length > 0) {
            s.println();
            this.printHelpNotes(s);
        }
        s.println();
        this.printHelpExitCodes(s);
        s.println();
        this.printHelpCopyright(s);
    }

    public void printHelpHeader(AppStream s) {
        HelpOption.printHelpHeader(this.getAppName(), this.getAppVersionSafe(), this.getAppDescription(), s);
    }

    public void printHelpOptions(AppStream s) {
        HelpOption.printHelpOptions(this.getAllOptions(), s);
    }

    public void printHelpNotes(AppStream s) {
        HelpOption.printHelpNotes(this.getHelpMessageNotes(), s);
    }

    public void printHelpExitCodes(AppStream s) {
        HelpOption.printHelpExitCodes(s);
    }

    public void printHelpCopyright(AppStream s) {
        HelpOption.printHelpCopyrightEclipseEscet(s);
    }

    public void printHelpLicense(AppStream s) {
        HelpOption.printHelpLicenseEclipseEscet(s);
    }

    public abstract String getAppName();

    public String getAppVersion() {
        Class<?> appClass = this.getClass();
        if (!Platform.isRunning()) {
            String msg = "OSGi Platform is not running. Override Application.getAppVersion for " + appClass.getName();
            throw new UnsupportedOperationException(msg);
        }
        Bundle bundle = FrameworkUtil.getBundle(appClass);
        if (bundle == null) {
            String msg = "Application class not defined by bundle class loader. Override Application.getAppVersion for " + appClass.getName();
            throw new UnsupportedOperationException(msg);
        }
        return bundle.getVersion().toString();
    }

    public String getAppVersionSafe() {
        try {
            return this.getAppVersion();
        }
        catch (UnsupportedOperationException e) {
            String version = "<version-could-not-be-determined>";
            return version;
        }
    }

    public abstract String getAppDescription();

    public String[] getHelpMessageNotes() {
        return new String[0];
    }

    public String getCrashReportIssueReportingInstructions() {
        return "Issues can be reported using the Eclipse ESCET issue tracker, at https://gitlab.eclipse.org/eclipse/escet/escet/-/issues. For more information, see https://eclipse.dev/escet/contact-and-support.html. This crash report contains valuable information that you can include in your bug report, to make it easier for the bug to be fixed. We appreciate you taking the effort to report issues to us!";
    }

    protected static OptionCategory getGeneralOptionCategory() {
        return new OptionCategory("General", "General application options.", Lists.list(), Lists.list((Object[])new Option[]{Options.getInstance(HelpOption.class), Options.getInstance(OptionDialogOption.class), Options.getInstance(OutputModeOption.class), Options.getInstance(LicenseOption.class), Options.getInstance(GuiOption.class), Options.getInstance(DevModeOption.class)}));
    }

    protected abstract OptionCategory getAllOptions();

    protected IOutputComponent getStreamOutputComponent(AppStream out, AppStream warn, AppStream err) {
        return new StreamOutputComponent(out, warn, err);
    }

    protected void preOptions() {
    }

    protected void postOptions() {
    }

    public boolean isTerminationRequested() {
        return this.appEnvData.isTerminationRequested();
    }

    public void terminate() {
        this.appEnvData.terminate();
    }

    public AppEnvData getAppEnvData() {
        return this.appEnvData;
    }

    public static class SuccessfulExitException
    extends RuntimeException {
    }
}

