/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.PlatformUriUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;

public class SourceFile {
    public final String absPath;
    public final boolean main;
    public final TextPosition importingPos;
    public final TextPosition problemPos;

    public SourceFile(String absPath, boolean main, TextPosition importingPos, TextPosition problemPos) {
        this.absPath = absPath;
        this.main = main;
        this.importingPos = importingPos;
        this.problemPos = problemPos;
        Assert.ifAndOnlyIf((boolean)main, (problemPos == null ? 1 : 0) != 0);
        Assert.ifAndOnlyIf((boolean)main, (importingPos == null ? 1 : 0) != 0);
    }

    public String getAbsDirPath() {
        return Paths.getAbsFilePathDir((String)this.absPath);
    }

    public String getRelativePathFrom(SourceFile mainFile) {
        Assert.check((!this.main ? 1 : 0) != 0);
        Assert.check((boolean)mainFile.main);
        String mainAbsDirPath = mainFile.getAbsDirPath();
        return PlatformUriUtils.getRelativePath((String)this.absPath, (String)mainAbsDirPath);
    }

    public String getRelativePathTo(String absPath) {
        return PlatformUriUtils.getRelativePath((String)absPath, (String)this.getAbsDirPath());
    }

    public String resolve(String path) {
        return PlatformUriUtils.resolve((String)path, (String)this.getAbsDirPath());
    }

    public String toString() {
        return Strings.fmt((String)"SourceFile(absPath=%s, main=%s, importingPos=%s, problemPos=%s)", (Object[])new Object[]{this.absPath, this.main, this.importingPos, this.problemPos});
    }
}

