/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Entry;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ExtensionVisitor;
import com.google.gdata.data.Link;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExtensionDescription.Default(nsAlias="gd", nsUri="http://schemas.google.com/g/2005", localName="entryLink")
public class EntryLink<E extends BaseEntry<?>>
extends Link {
    protected boolean readOnly;
    protected BaseEntry<?> entry;
    protected final Class<E> entryClass;

    public EntryLink() {
        this(Entry.class);
    }

    public EntryLink(Class<E> entryClass) {
        this.entryClass = entryClass;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean v) {
        this.readOnly = v;
    }

    public E getEntry() {
        return (E)this.entry;
    }

    public void setEntry(E v) {
        this.entry = v;
    }

    public Class<E> getEntryClass() {
        return this.entryClass;
    }

    public static ExtensionDescription getDefaultDescription() {
        return ExtensionDescription.getDefaultDescription(EntryLink.class);
    }

    @Override
    public String getType() {
        return ContentType.getAtomEntry().toString();
    }

    @Override
    protected void visitChildren(ExtensionVisitor ev) throws ExtensionVisitor.StoppedException {
        if (this.entry != null) {
            this.visitChild(ev, this.entry);
        }
        super.visitChildren(ev);
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        if (this.rel != null) {
            attrs.add(new XmlWriter.Attribute("rel", this.rel));
        }
        if (this.href != null) {
            attrs.add(new XmlWriter.Attribute("href", this.href));
        }
        if (this.readOnly) {
            attrs.add(new XmlWriter.Attribute("readOnly", "true"));
        }
        this.generateStartElement(w, Namespaces.gNs, "entryLink", attrs, null);
        if (this.entry != null) {
            ExtensionProfile nestedExtProfile = extProfile.getEntryLinkProfile();
            if (nestedExtProfile == null) {
                nestedExtProfile = extProfile;
            }
            this.entry.generateAtom(w, nestedExtProfile);
        }
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.gNs, "entryLink");
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new Handler(extProfile);
    }

    private class Handler
    extends Link.AtomHandler {
        public Handler(ExtensionProfile extProfile) {
            super(extProfile, EntryLink.class);
        }

        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            if (namespace.equals("")) {
                if (localName.equals("readOnly")) {
                    EntryLink.this.readOnly = value.equals("true");
                } else {
                    super.processAttribute(namespace, localName, value);
                }
            }
        }

        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (namespace.equals("http://www.w3.org/2005/Atom") && localName.equals("entry")) {
                ExtensionProfile nestedExtProfile = this.extProfile.getEntryLinkProfile();
                if (nestedExtProfile == null) {
                    nestedExtProfile = this.extProfile;
                }
                try {
                    EntryLink.this.entry = (BaseEntry)EntryLink.this.entryClass.newInstance();
                }
                catch (IllegalAccessException iae) {
                    throw new ParseException(CoreErrorDomain.ERR.cantCreateEntry);
                }
                catch (InstantiationException ie) {
                    throw new ParseException(CoreErrorDomain.ERR.cantCreateEntry);
                }
                BaseEntry<?> baseEntry = EntryLink.this.entry;
                baseEntry.getClass();
                return baseEntry.new BaseEntry.AtomHandler(nestedExtProfile);
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }
}

