/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.util.MatlabEngineUtil;
import org.eclipse.epsilon.emc.simulink.util.manager.Manager;

public abstract class AbstractSimulinkCollection<E, P, M extends Manager<E, P>>
implements List<ISimulinkModelElement> {
    protected List<P> primitive;
    protected M manager;

    public AbstractSimulinkCollection(Object primitive, M manager) {
        if (primitive != null) {
            if (this.isInstanceOfPrimitiveArray(primitive)) {
                this.primitive = this.getPrimitiveFromArray(primitive);
            } else if (primitive instanceof List) {
                this.primitive = this.getPrimitiveFromList((List)primitive);
            } else if (this.isInstanceOfPrimitive(primitive)) {
                this.primitive = this.getPrimitiveFromSingle(primitive);
            } else {
                this.primitive = new ArrayList<P>();
                this.primitive.add(primitive);
            }
        } else {
            this.primitive = new ArrayList<P>();
        }
        this.manager = manager;
    }

    protected List<P> getPrimitiveFromSingle(Object primitive) {
        return new ArrayList<Object>(Arrays.asList(primitive));
    }

    protected List<P> getPrimitiveFromList(List<?> primitive) {
        return primitive;
    }

    protected List<P> getPrimitiveFromArray(Object primitive) {
        return MatlabEngineUtil.matlabArrayToList((Object[])primitive);
    }

    @Override
    public int size() {
        return this.getPrimitive().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getPrimitive().isEmpty();
    }

    @Override
    public void clear() {
        this.getPrimitive().clear();
    }

    @Override
    public Iterator<ISimulinkModelElement> iterator() {
        return this.getInternalIterator();
    }

    @Override
    public ISimulinkModelElement remove(int index) {
        ISimulinkModelElement element = this.get(index);
        this.getPrimitive().remove(index);
        return element;
    }

    @Override
    public ISimulinkModelElement get(int index) {
        P handle = this.getPrimitive().get(index);
        return (ISimulinkModelElement)this.manager.construct(handle);
    }

    @Override
    public boolean add(ISimulinkModelElement e) {
        int size = this.getPrimitive().size();
        this.getPrimitive().add(this.manager.getId((ISimulinkModelElement)e));
        return this.getPrimitive().size() == size + 1;
    }

    public boolean addPrimitive(Object primitive) {
        if (primitive != null) {
            if (this.isInstanceOfPrimitiveArray(primitive)) {
                this.getPrimitive().addAll(this.getPrimitiveFromArray(primitive));
            } else if (primitive instanceof List) {
                this.getPrimitive().addAll(this.getPrimitiveFromList((List)primitive));
            } else if (this.isInstanceOfPrimitive(primitive)) {
                this.getPrimitive().addAll(this.getPrimitiveFromSingle(primitive));
            } else {
                this.getPrimitive().add(primitive);
            }
            return true;
        }
        return false;
    }

    public boolean removePrimitive(Object primitive) {
        if (primitive != null) {
            if (this.isInstanceOfPrimitiveArray(primitive)) {
                this.getPrimitive().removeAll(this.getPrimitiveFromArray(primitive));
            } else if (primitive instanceof List) {
                this.getPrimitive().removeAll(this.getPrimitiveFromList((List)primitive));
            } else if (this.isInstanceOfPrimitive(primitive)) {
                this.getPrimitive().removeAll(this.getPrimitiveFromSingle(primitive));
            } else {
                this.getPrimitive().remove(primitive);
            }
            return true;
        }
        return false;
    }

    @Override
    public ISimulinkModelElement set(int index, ISimulinkModelElement element) {
        ISimulinkModelElement previous = this.get(index);
        this.getPrimitive().set(index, this.manager.getId((ISimulinkModelElement)element));
        return previous;
    }

    @Override
    public void add(int index, ISimulinkModelElement element) {
        this.getPrimitive().add(index, this.manager.getId((ISimulinkModelElement)element));
    }

    @Override
    public int indexOf(Object o) {
        if (this.isInstanceOf(o)) {
            return this.getPrimitive().indexOf(this.manager.getId((Object)o));
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        if (this.isInstanceOf(o)) {
            return this.getPrimitive().contains(this.manager.getId((Object)o));
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.isInstanceOf(o)) {
            return this.getPrimitive().remove(this.manager.getId((Object)o));
        }
        return false;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (this.isInstanceOf(o)) {
            return this.getPrimitive().lastIndexOf(this.manager.getId((Object)o));
        }
        return -1;
    }

    @Override
    public boolean addAll(Collection<? extends ISimulinkModelElement> c) {
        if (c instanceof AbstractSimulinkCollection) {
            AbstractSimulinkCollection collection = (AbstractSimulinkCollection)c;
            return this.getPrimitive().addAll(collection.getPrimitive());
        }
        int original = this.getPrimitive().size();
        c.stream().forEach(e -> {
            boolean bl = this.getPrimitive().add(this.manager.getId((ISimulinkModelElement)e));
        });
        return original + c.size() == this.getPrimitive().size();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof AbstractSimulinkCollection) {
            AbstractSimulinkCollection collection = (AbstractSimulinkCollection)c;
            return this.getPrimitive().containsAll(collection.getPrimitive());
        }
        return c.parallelStream().filter(e -> this.isInstanceOf(e)).map(e -> this.getPrimitive().contains(this.manager.getId((Object)e))).reduce(Boolean::logicalAnd).orElse(false);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ISimulinkModelElement> c) {
        if (c instanceof AbstractSimulinkCollection) {
            AbstractSimulinkCollection collection = (AbstractSimulinkCollection)c;
            return this.getPrimitive().addAll(collection.getPrimitive());
        }
        return c.parallelStream().filter(e -> this.isInstanceOf(e)).map(e -> this.getPrimitive().add(this.manager.getId((ISimulinkModelElement)e))).reduce(Boolean::logicalAnd).orElse(false);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof AbstractSimulinkCollection) {
            AbstractSimulinkCollection collection = (AbstractSimulinkCollection)c;
            return this.getPrimitive().removeAll(collection.getPrimitive());
        }
        return c.parallelStream().filter(e -> this.isInstanceOf(e)).map(e -> this.getPrimitive().remove(this.manager.getId((Object)e))).reduce(Boolean::logicalAnd).orElse(false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof AbstractSimulinkCollection) {
            AbstractSimulinkCollection collection = (AbstractSimulinkCollection)c;
            return this.getPrimitive().retainAll(collection.getPrimitive());
        }
        List collect = c.parallelStream().filter(e -> this.isInstanceOf(e)).map(e -> this.manager.getId((Object)e)).collect(Collectors.toList());
        return this.getPrimitive().retainAll(collect);
    }

    @Override
    public Object[] toArray() {
        return this.getPrimitive().stream().map(e -> this.getManager().construct((Object)e)).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getPrimitive().stream().map(e -> this.getManager().construct((Object)e)).toArray((int i) -> a);
    }

    public M getManager() {
        return this.manager;
    }

    public List<P> getPrimitive() {
        return this.primitive;
    }

    protected abstract boolean isInstanceOf(Object var1);

    protected abstract boolean isInstanceOfPrimitive(Object var1);

    protected abstract boolean isInstanceOfPrimitiveArray(Object var1);

    protected abstract Iterator<ISimulinkModelElement> getInternalIterator();
}

