/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.utils;

import com.fasterxml.jackson.databind.DatabindContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emfcloud.jackson.databind.EMFContext;

public final class EObjects {
    private static final Map<EClass, Optional<EStructuralFeature>> ELEMENT_WILDCARD_CACHE = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<EClass, Optional<EStructuralFeature>> ATTRIBUTE_WILDCARD_CACHE = Collections.synchronizedMap(new WeakHashMap());

    private EObjects() {
    }

    public static void setOrAdd(EObject owner, EReference reference, Object value) {
        if (value != null) {
            if (reference.isMany()) {
                Collection values = (Collection)owner.eGet((EStructuralFeature)reference, false);
                if (values != null && value instanceof EObject) {
                    values.add((EObject)value);
                }
            } else {
                owner.eSet((EStructuralFeature)reference, value);
            }
        }
    }

    public static boolean isContainmentProxy(DatabindContext ctxt, EObject owner, EObject contained) {
        if (contained.eIsProxy()) {
            return true;
        }
        Resource ownerResource = EMFContext.getResource(ctxt, owner);
        Resource containedResource = EMFContext.getResource(ctxt, contained);
        return ownerResource != null && ownerResource != containedResource;
    }

    public static EObject createEntry(String key, Object value, EClass type) {
        if (type == EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY) {
            EObject entry = EcoreUtil.create((EClass)EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY);
            entry.eSet((EStructuralFeature)EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY__KEY, (Object)key);
            entry.eSet((EStructuralFeature)EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY__VALUE, value);
            return entry;
        }
        DynamicEObjectImpl.BasicEMapEntry entry = new DynamicEObjectImpl.BasicEMapEntry();
        entry.eSetClass(type);
        entry.setKey((Object)key);
        entry.setValue(value);
        return entry;
    }

    public static boolean isFeatureMapEntry(EStructuralFeature feature) {
        EAnnotation annotation;
        if (feature != null && (annotation = feature.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData")) != null) {
            return annotation.getDetails().containsKey((Object)ExtendedMetaData.FEATURE_KINDS[6]) || ExtendedMetaData.INSTANCE.getFeatureKind(feature) == 4 && ELEMENT_WILDCARD_CACHE.computeIfAbsent(feature.getEContainingClass(), EObjects::getElementWildcard).isPresent() || ExtendedMetaData.INSTANCE.getFeatureKind(feature) == 2 && ATTRIBUTE_WILDCARD_CACHE.computeIfAbsent(feature.getEContainingClass(), EObjects::getAttributeWildcard).isPresent();
        }
        return false;
    }

    public static String getGroupNameForFeatureMapEntry(EStructuralFeature featureMapEntry) {
        Supplier<IllegalArgumentException> illegal = () -> new IllegalArgumentException(featureMapEntry.getName());
        EAnnotation annotation = featureMapEntry.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        if (annotation == null) {
            throw illegal.get();
        }
        String group = (String)annotation.getDetails().get((Object)ExtendedMetaData.FEATURE_KINDS[6]);
        return Optional.ofNullable(group).map(g -> g.startsWith("#") ? g.substring(1) : g).orElseGet(() -> {
            EStructuralFeature wildcard;
            if (ExtendedMetaData.INSTANCE.getFeatureKind(featureMapEntry) == 4) {
                wildcard = (EStructuralFeature)ELEMENT_WILDCARD_CACHE.computeIfAbsent(featureMapEntry.getEContainingClass(), EObjects::getElementWildcard).orElseThrow(illegal);
            } else if (ExtendedMetaData.INSTANCE.getFeatureKind(featureMapEntry) == 2) {
                wildcard = (EStructuralFeature)ATTRIBUTE_WILDCARD_CACHE.computeIfAbsent(featureMapEntry.getEContainingClass(), EObjects::getAttributeWildcard).orElseThrow(illegal);
            } else {
                throw (IllegalArgumentException)illegal.get();
            }
            return wildcard.getName();
        });
    }

    private static Optional<EStructuralFeature> getElementWildcard(EClass type) {
        Stream<EStructuralFeature> featureMapAtts = type.getEAllStructuralFeatures().stream().filter(FeatureMapUtil::isFeatureMap);
        return featureMapAtts.filter(r -> ExtendedMetaData.INSTANCE.getFeatureKind(r) == 5).findFirst();
    }

    private static Optional<EStructuralFeature> getAttributeWildcard(EClass type) {
        Stream<EStructuralFeature> featureMapAtts = type.getEAllStructuralFeatures().stream().filter(FeatureMapUtil::isFeatureMap);
        return featureMapAtts.filter(r -> ExtendedMetaData.INSTANCE.getFeatureKind(r) == 3).findFirst();
    }
}

