/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.ser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.CollectionSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EEnumLiteralImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntry;
import org.eclipse.emfcloud.jackson.databind.property.EObjectPropertyMap;
import org.eclipse.emfcloud.jackson.databind.ser.EDataTypeSerializer;
import org.eclipse.emfcloud.jackson.databind.ser.EMapKeySerializer;
import org.eclipse.emfcloud.jackson.databind.ser.EMapSerializer;
import org.eclipse.emfcloud.jackson.databind.ser.EMapValueSerializer;
import org.eclipse.emfcloud.jackson.databind.ser.EObjectSerializer;
import org.eclipse.emfcloud.jackson.databind.ser.EnumeratorSerializer;
import org.eclipse.emfcloud.jackson.databind.ser.ResourceSerializer;
import org.eclipse.emfcloud.jackson.databind.type.EcoreType;
import org.eclipse.emfcloud.jackson.module.EMFModule;

public class EMFSerializers
extends Serializers.Base {
    private final EObjectPropertyMap.Builder propertiesBuilder;
    private final JsonSerializer<FeatureMap.Entry> featureMapEntrySerializer;
    private final JsonSerializer<EObject> referenceSerializer;
    private final JsonSerializer<Resource> resourceSerializer = new ResourceSerializer();
    private final JsonSerializer<?> dataTypeSerializer = new EDataTypeSerializer();
    private final JsonSerializer<Object> mapKeySerializer = new EMapKeySerializer();
    private final JsonSerializer<Object> mapValueSerializer = new EMapValueSerializer();
    private final JsonSerializer<?> enumeratorSerializer = new EnumeratorSerializer();

    public EMFSerializers(EMFModule module) {
        this.propertiesBuilder = EObjectPropertyMap.Builder.from(module, module.getFeatures());
        this.featureMapEntrySerializer = module.getFeatureMapEntrySerializer();
        this.referenceSerializer = module.getReferenceSerializer();
    }

    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig config, MapLikeType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        if (type.isTypeOrSubTypeOf(EMap.class)) {
            JsonSerializer<Object> keySer = Optional.ofNullable(keySerializer).orElse(this.mapKeySerializer);
            JsonSerializer<Object> valueSer = Optional.ofNullable(elementValueSerializer).orElse(this.mapValueSerializer);
            MapSerializer mapSer = MapSerializer.construct(Set.of(), (JavaType)type, (boolean)false, (TypeSerializer)elementTypeSerializer, keySer, valueSer, null);
            return new EMapSerializer(mapSer);
        }
        return super.findMapLikeSerializer(config, type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer);
    }

    public JsonSerializer<?> findCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription beanDesc, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        if (type.getContentType().isReferenceType()) {
            return new CollectionSerializer(type.getContentType(), false, null, this.referenceSerializer);
        }
        return super.findCollectionSerializer(config, type, beanDesc, elementTypeSerializer, elementValueSerializer);
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        if (type.isTypeOrSubTypeOf(Resource.class)) {
            return this.resourceSerializer;
        }
        if (type.isTypeOrSubTypeOf(Enumerator.class) && !type.isReferenceType() && type.getRawClass() != EEnumLiteralImpl.class) {
            return this.enumeratorSerializer;
        }
        if (type.isReferenceType() || type.isTypeOrSubTypeOf(ReferenceEntry.class)) {
            return this.referenceSerializer;
        }
        if (type.isTypeOrSubTypeOf(EcoreType.DataType.class)) {
            return this.dataTypeSerializer;
        }
        if (type.isTypeOrSubTypeOf(EObject.class)) {
            return new EObjectSerializer(this.propertiesBuilder, this.referenceSerializer);
        }
        if (type.isTypeOrSubTypeOf(FeatureMap.Entry.class)) {
            return this.featureMapEntrySerializer;
        }
        return super.findSerializer(config, type, beanDesc);
    }
}

