/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CherryPickDialog
extends Dialog {
    static final Logger logger = LoggerFactory.getLogger(CherryPickDialog.class);
    private String commitMessage;
    private String[] branchesRef;
    private Text msgTextData;
    private Composite buttonComposite;
    private Button cancel;
    private Combo fBranch;
    private String fBranchText;
    private String fMessageText;

    public CherryPickDialog(Composite parent, List<String> listBranchesRef, String message) {
        super(parent.getShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        logger.debug("Open the Reply dialog.");
        this.branchesRef = new String[listBranchesRef.size()];
        this.branchesRef = listBranchesRef.toArray(new String[listBranchesRef.size()]);
        this.commitMessage = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CherryPickDialog_0);
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Label lblBranch = new Label(parent, 16384);
        this.fBranch = new Combo(parent, 0);
        this.addContentProposal(this.fBranch);
        GridData gd_combo = new GridData(4, 4, true, false, 1, 3);
        gd_combo.verticalIndent = 5;
        gd_combo.grabExcessVerticalSpace = false;
        lblBranch.setText(Messages.CherryPickDialog_1);
        lblBranch.setLayoutData((Object)gd_combo);
        this.fBranch.setLayoutData((Object)gd_combo);
        this.fBranch.setItems(this.branchesRef);
        Label lblMessage = new Label(parent, 16384);
        lblMessage.setText(Messages.CherryPickDialog_2);
        GridData gridlbl = new GridData(4, 4, true, false, 1, 3);
        gridlbl.verticalIndent = 20;
        lblMessage.setLayoutData((Object)gridlbl);
        ScrolledComposite sc_msgtxt = new ScrolledComposite(parent, 2816);
        sc_msgtxt.setExpandHorizontal(true);
        sc_msgtxt.setExpandVertical(true);
        GridData grid = new GridData(4, 4, true, true, 1, 1);
        this.msgTextData = new Text((Composite)sc_msgtxt, 66);
        sc_msgtxt.setLayoutData((Object)grid);
        sc_msgtxt.setContent((Control)this.msgTextData);
        this.msgTextData.setText(this.commitMessage);
        this.createBottomButtons(parent);
        parent.getShell().setMinimumSize(500, 300);
        return parent;
    }

    private void addContentProposal(Combo combo) {
        IContentProposalProvider cp = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<ContentProposal> resultList = new ArrayList<ContentProposal>();
                String[] stringArray = CherryPickDialog.this.branchesRef;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String branch = stringArray[n2];
                    if (branch.indexOf(contents) != -1) {
                        resultList.add(new ContentProposal(branch));
                    }
                    ++n2;
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        };
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)combo, (IControlContentAdapter)new ComboContentAdapter(), cp, null, null);
        adapter.setProposalAcceptanceStyle(2);
    }

    private void createBottomButtons(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData sepGrid = new GridData(768);
        sepGrid.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)sepGrid);
        this.buttonComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        this.buttonComposite.setLayout((Layout)gridLayout);
        GridData gd_button = new GridData(4, 0x1000000, true, false);
        gd_button.grabExcessHorizontalSpace = true;
        this.buttonComposite.setLayoutData((Object)gd_button);
        this.createButton(this.buttonComposite, 0, Messages.CherryPickDialog_3, false);
        this.cancel = this.createButton(this.buttonComposite, 1, IDialogConstants.CANCEL_LABEL, true);
        GridData gd_cancel = new GridData(131072, 0x1000000, false, false);
        gd_cancel.grabExcessHorizontalSpace = true;
        this.cancel.setLayoutData((Object)gd_cancel);
    }

    protected void okPressed() {
        this.fBranchText = this.fBranch.getText();
        this.fMessageText = this.msgTextData.getText();
        super.okPressed();
    }

    public String getMessage() {
        return this.fMessageText;
    }

    public String getBranch() {
        return this.fBranchText;
    }
}

