/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.GetContentFromCommitCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.compare.GerritCompareHelper;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommitCompareItem
extends CommentableCompareItem
implements IStreamContentAccessor,
ITypedElement {
    private static Logger logger = LoggerFactory.getLogger(CommitCompareItem.class);
    private static final String PARENT = "PARENT";
    private final String projectId;
    private final String commitId;
    private String showAsRevision;
    private String filePath;

    public CommitCompareItem(GerritClient gerrit, String projectId, String commitId, FileInfo fileInfo, String fileName, String showAsRevision) {
        super(PARENT);
        this.gerrit = gerrit;
        this.projectId = projectId;
        this.commitId = commitId;
        this.fileInfo = fileInfo;
        this.showAsRevision = showAsRevision;
    }

    public String getName() {
        if (this.showAsRevision != null) {
            return NLS.bind((String)Messages.CompareElementPatchSetWithCommitId, (Object[])new Object[]{this.showAsRevision, GerritCompareHelper.extractFilename(this.getOldPathOrPath()), GerritCompareHelper.shortenCommitId(this.commitId)});
        }
        return NLS.bind((String)Messages.CompareElementBase, (Object)GerritCompareHelper.extractFilename(this.getOldPathOrPath()), (Object)GerritCompareHelper.shortenCommitId(this.commitId));
    }

    private String getOldPathOrPath() {
        if (this.filePath != null) {
            return this.filePath;
        }
        if (this.fileInfo.getOld_path() == null) {
            return this.fileInfo.getPath();
        }
        return this.fileInfo.getOld_path();
    }

    @Override
    protected byte[] loadFileContent() {
        GetContentFromCommitCommand getContent = this.gerrit.getContentFromCommit(this.projectId, this.commitId, this.getOldPathOrPath());
        try {
            String encodedFile = (String)getContent.call();
            this.setFileType(getContent.getFileMimeType());
            return Base64.decodeBase64((String)encodedFile);
        }
        catch (EGerritException e) {
            logger.debug("Exception retrieving commitId", (Throwable)e);
            return new byte[0];
        }
    }

    @Override
    protected EList<CommentInfo> filterComments(EList<CommentInfo> eList) {
        return (EList)eList.stream().filter(comment -> PARENT.equals(comment.getSide())).collect(Collectors.toCollection(BasicEList::new));
    }
}

