/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core.command;

import java.lang.reflect.Type;
import org.apache.http.client.methods.HttpRequestBase;
import org.eclipse.egerrit.internal.core.GerritRepository;
import org.eclipse.egerrit.internal.core.command.AuthentificationRequired;
import org.eclipse.egerrit.internal.core.command.BaseCommand;

abstract class BaseCommandChange<T>
extends BaseCommand<T> {
    private static final String CHANGE_ID = "{change-id}";
    private static final String REVISION_ID = "{revision-id}";

    protected BaseCommandChange(GerritRepository gerritRepository, AuthentificationRequired authRequired, Class<? extends HttpRequestBase> operationType, Type returnType, String changeId) {
        super(gerritRepository, authRequired, operationType, returnType);
        this.setSegment(CHANGE_ID, changeId);
    }

    protected BaseCommandChange(GerritRepository gerritRepository, AuthentificationRequired authRequired, Class<? extends HttpRequestBase> operationType, Type returnType, String changeId, String revisionId) {
        super(gerritRepository, authRequired, operationType, returnType);
        this.setSegment(CHANGE_ID, changeId);
        this.setSegment(REVISION_ID, revisionId);
    }

    @Override
    protected void setPathFormat(String pathFormat) {
        super.setPathFormat(pathFormat);
        if (!pathFormat.contains(CHANGE_ID)) {
            throw new IllegalArgumentException("The string {change-id} is not found");
        }
    }
}

