/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Consumer;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.event.Event;
import org.eclipse.fx.core.event.GlobalEventBus;
import org.eclipse.fx.core.event.Topic;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@Component
public class OSGiEventBusImpl
implements GlobalEventBus {
    private static final String DATA = "org.eclipse.e4.data";
    private EventAdmin eventAdmin;

    @Reference
    synchronized void registerMessageService(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    synchronized void unregisterMessageService(EventAdmin eventAdmin) {
        if (this.eventAdmin != null && this.eventAdmin.equals(eventAdmin)) {
            this.eventAdmin = null;
        }
    }

    @Override
    public <T> void publish(Event<T> event, boolean synchronous) {
        Hashtable<String, String> d = new Hashtable<String, String>(2);
        ((Dictionary)d).put("event.topics", event.getTopic());
        ((Dictionary)d).put(DATA, (String)event.getData());
        org.osgi.service.event.Event osgiEvent = new org.osgi.service.event.Event(event.getTopic(), d);
        if (synchronous) {
            this.eventAdmin.sendEvent(osgiEvent);
        } else {
            this.eventAdmin.postEvent(osgiEvent);
        }
    }

    @Override
    public <T> void publish(Topic<T> topic, T data, boolean synchronous) {
        Hashtable<String, String> d = new Hashtable<String, String>(2);
        ((Dictionary)d).put("event.topics", topic.topic);
        ((Dictionary)d).put(DATA, (String)data);
        org.osgi.service.event.Event event = new org.osgi.service.event.Event(topic.topic, d);
        if (synchronous) {
            this.eventAdmin.sendEvent(event);
        } else {
            this.eventAdmin.postEvent(event);
        }
    }

    @Override
    public void publish(String topic, Object data, boolean synchronous) {
        this.publish(new Topic(topic), data, synchronous);
    }

    @Override
    public <T> Subscription subscribe(Topic<T> topic, Consumer<Event<T>> consumer) {
        EventHandler handler = event -> {
            Object data = event.getProperty(DATA);
            consumer.accept(new Event<Object>(topic, data));
        };
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        ((Dictionary)properties).put("event.topics", topic.topic);
        BundleContext bundleContext = FrameworkUtil.getBundle(OSGiEventBusImpl.class).getBundleContext();
        ServiceRegistration serviceRegistration = bundleContext.registerService(EventHandler.class, (Object)handler, properties);
        return () -> serviceRegistration.unregister();
    }

    @Override
    public <T> Subscription subscribe(String topic, Consumer<Event<T>> consumer) {
        return this.subscribe(new Topic(topic), consumer);
    }
}

