/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.ui.highlighting;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.ide.css.cssDsl.CssTok;
import org.eclipse.fx.ide.css.cssDsl.ElementSelector;
import org.eclipse.fx.ide.css.cssDsl.FuncTok;
import org.eclipse.fx.ide.css.cssDsl.IdentifierTok;
import org.eclipse.fx.ide.css.cssDsl.StringTok;
import org.eclipse.fx.ide.css.cssDsl.SymbolTok;
import org.eclipse.fx.ide.css.cssDsl.URLType;
import org.eclipse.fx.ide.css.cssDsl.css_declaration;
import org.eclipse.fx.ide.css.cssDsl.simple_selector;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;

public class CssDslHighlightingCalculator
implements ISemanticHighlightingCalculator {
    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (resource == null) {
            return;
        }
        TreeIterator it = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (it.hasNext()) {
            ICompositeNode n;
            ICompositeNode n2;
            Object o = it.next();
            if (o instanceof ElementSelector) {
                n2 = NodeModelUtils.getNode((EObject)((EObject)o));
                if (n2 == null) continue;
                acceptor.addPosition(n2.getOffset(), n2.getLength(), new String[]{"ELEMENT"});
                continue;
            }
            if (o instanceof IdentifierTok) {
                n2 = NodeModelUtils.getNode((EObject)((EObject)o));
                if (n2 == null) continue;
                acceptor.addPosition(n2.getOffset(), n2.getLength(), new String[]{"default"});
                continue;
            }
            if (o instanceof css_declaration) {
                css_declaration dec = (css_declaration)o;
                if (dec.getProperty() == null || dec.getProperty().getName() == null || dec.getProperty().getName().trim().length() <= 0 || (n = NodeModelUtils.getNode((EObject)dec)) == null || !n.hasChildren()) continue;
                acceptor.addPosition(n.getFirstChild().getOffset(), n.getFirstChild().getLength(), new String[]{"DeclarationName"});
                continue;
            }
            if (o instanceof simple_selector) {
                n2 = NodeModelUtils.getNode((EObject)((EObject)o));
                if (n2 == null) continue;
                acceptor.addPosition(n2.getOffset(), n2.getLength(), new String[]{"Selector"});
                continue;
            }
            if (o instanceof URLType) {
                URLType url = (URLType)o;
                n = NodeModelUtils.getNode((EObject)url);
                if (n == null) continue;
                acceptor.addPosition(n.getOffset(), 4, new String[]{"Function"});
                acceptor.addPosition(n.getOffset() + 4, n.getLength() - 5, new String[]{"Url"});
                acceptor.addPosition(n.getOffset() + n.getLength() - 1, 1, new String[]{"Function"});
                continue;
            }
            if (o instanceof FuncTok) {
                FuncTok funcTok = (FuncTok)o;
                n = NodeModelUtils.getNode((EObject)funcTok);
                int nameLength = funcTok.getName().getName().length();
                if (n != null) {
                    acceptor.addPosition(n.getOffset(), nameLength + 1, new String[]{"Function"});
                }
                for (CssTok tok : ((FuncTok)o).getParams()) {
                    ICompositeNode colonNode;
                    if (!(tok instanceof SymbolTok) || !",".equals(((SymbolTok)tok).getSymbol()) || (colonNode = NodeModelUtils.getNode((EObject)tok)) == null) continue;
                    acceptor.addPosition(colonNode.getOffset(), colonNode.getLength(), new String[]{"Function"});
                }
                if (n == null) continue;
                acceptor.addPosition(n.getOffset() + n.getLength() - 1, 1, new String[]{"Function"});
                continue;
            }
            if (!(o instanceof StringTok) || (n2 = NodeModelUtils.getNode((EObject)((EObject)o))) == null) continue;
            acceptor.addPosition(n2.getOffset(), n2.getLength(), new String[]{"string"});
        }
    }
}

