/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ReuseCache<T> {
    private Supplier<T> factory;
    private List<Consumer<T>> onActivate = new ArrayList<Consumer<T>>();
    private List<Consumer<T>> onRelease = new ArrayList<Consumer<T>>();
    private List<Consumer<T>> onClear = new ArrayList<Consumer<T>>();
    private Stack<T> free = new Stack();
    private Set<T> active = new HashSet<T>();

    public ReuseCache(Supplier<T> factory) {
        this.factory = factory;
    }

    public void addOnActivate(Consumer<T> onActivate) {
        this.onActivate.add(onActivate);
    }

    public void addOnRelease(Consumer<T> onRelease) {
        this.onRelease.add(onRelease);
    }

    public void addOnClear(Consumer<T> onClear) {
        this.onClear.add(onClear);
    }

    public T getElement() {
        Object element = this.free.isEmpty() ? this.factory.get() : this.free.pop();
        this.active.add(element);
        this.onActivate.forEach(a -> a.accept(element));
        return element;
    }

    public void releaseElement(T element) {
        this.active.remove(element);
        this.onRelease.forEach(a -> a.accept(element));
    }

    public void clearFreeElements() {
        this.free.clear();
    }

    public boolean isActive(T element) {
        this.onClear.forEach(onClear -> onClear.accept(element));
        return this.active.contains(element);
    }
}

