/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.filesystem.skin;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.eclipse.fx.ui.controls.filesystem.DirItem;
import org.eclipse.fx.ui.controls.filesystem.DirectoryView;
import org.eclipse.fx.ui.controls.filesystem.FileItem;
import org.eclipse.fx.ui.controls.filesystem.IconSize;
import org.eclipse.fx.ui.controls.filesystem.ResourceEvent;
import org.eclipse.fx.ui.controls.filesystem.ResourceItem;

public class DirectoryViewSkin
extends SkinBase<DirectoryView> {
    private final ObservableList<ResourceItem> selectedItems;
    private DirItem currentItem;
    private TableView<ResourceItem> tableView;

    public DirectoryViewSkin(DirectoryView control, ObservableList<ResourceItem> selectedItems) {
        super((Control)control);
        this.selectedItems = selectedItems;
        control.dirProperty().addListener(this::pathChangedHandler);
        this.setupView();
        this.pathChangedHandler((Observable)((DirectoryView)this.getSkinnable()).dirProperty());
    }

    private void openSelectedResources() {
        Event.fireEvent((EventTarget)this.getSkinnable(), ResourceEvent.createOpenResource((Node)this.getSkinnable(), ((DirectoryView)this.getSkinnable()).getSelectedItems()));
    }

    private void setupView() {
        switch (((DirectoryView)this.getSkinnable()).getDisplayType()) {
            // Empty switch
        }
        Node n = this.setupListView();
        this.getChildren().setAll((Object[])new Node[]{n});
    }

    private Node setupListView() {
        this.tableView = new TableView();
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ResourceBundle b = ResourceBundle.getBundle("org.eclipse.fx.ui.controls.filesystem.skin.resource");
        TableColumn c = new TableColumn(b.getString("DirectoryViewSkin_Name"));
        c.setPrefWidth(400.0);
        c.setMinWidth(400.0);
        c.setCellFactory(co -> new NameTableCell());
        c.setCellValueFactory(cdf -> new SimpleObjectProperty((Object)((ResourceItem)cdf.getValue())));
        this.tableView.getColumns().add((Object)c);
        c = new TableColumn(b.getString("DirectoryViewSkin_ChangeDate"));
        c.setMinWidth(100.0);
        c.setCellFactory(co -> new LastModifiedCell());
        c.setCellValueFactory(cdf -> ((ResourceItem)cdf.getValue()).lastModifiedProperty());
        this.tableView.getColumns().add((Object)c);
        c = new TableColumn(b.getString("DirectoryViewSkin_Size"));
        c.setCellFactory(co -> new SizeCell());
        c.setCellValueFactory(cdf -> {
            if (cdf.getValue() instanceof DirItem) {
                return new SimpleObjectProperty(null);
            }
            return ((FileItem)cdf.getValue()).fileSizeProperty();
        });
        c.setMinWidth(100.0);
        this.tableView.getColumns().add((Object)c);
        this.tableView.setOnMouseReleased(e -> {
            if (e.getClickCount() == 2) {
                this.openSelectedResources();
            }
        });
        Bindings.bindContent(this.selectedItems, (ObservableList)this.tableView.getSelectionModel().getSelectedItems());
        return this.tableView;
    }

    private void pathChangedHandler(Observable o) {
        this.currentItem = ((DirectoryView)this.getSkinnable()).getDir();
        if (this.currentItem != null) {
            this.tableView.setItems(this.currentItem.getChildren());
        } else {
            this.tableView.setItems(FXCollections.observableArrayList());
        }
    }

    static int size(IconSize s) {
        switch (s) {
            case SMALL: {
                return 26;
            }
            case MEDIUM: {
                return 42;
            }
        }
        return 58;
    }

    class LastModifiedCell
    extends TableCell<ResourceItem, LocalDateTime> {
        public LastModifiedCell() {
            this.setAlignment(Pos.CENTER_LEFT);
        }

        protected void updateItem(LocalDateTime item, boolean empty) {
            if (item != null && !empty) {
                this.setText(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(item));
            } else {
                this.setText(null);
            }
            super.updateItem((Object)item, empty);
        }
    }

    class NameTableCell
    extends TableCell<ResourceItem, ResourceItem> {
        NameTableCell() {
        }

        protected void updateItem(ResourceItem item, boolean empty) {
            if (item != null && !empty) {
                Label l = new Label();
                ImageView v = new ImageView();
                if (item instanceof DirItem) {
                    v.getStyleClass().add((Object)(switch (((DirectoryView)DirectoryViewSkin.this.getSkinnable()).getIconSize()) {
                        case IconSize.SMALL -> "folderSmall";
                        case IconSize.MEDIUM -> "folderMedium";
                        default -> "folderBig";
                    }));
                } else if (item.getName().endsWith(".gif") || item.getName().endsWith(".png") || item.getName().endsWith(".jpg")) {
                    int size = switch (((DirectoryView)DirectoryViewSkin.this.getSkinnable()).getIconSize()) {
                        case IconSize.SMALL -> 16;
                        case IconSize.MEDIUM -> 32;
                        default -> 48;
                    };
                    Image img = new Image(item.getUri(), (double)size, (double)size, true, true, true);
                    v.setImage(img);
                } else {
                    v.getStyleClass().add((Object)(switch (((DirectoryView)DirectoryViewSkin.this.getSkinnable()).getIconSize()) {
                        case IconSize.SMALL -> "fileSmall";
                        case IconSize.MEDIUM -> "fileMedium";
                        default -> "fileBig";
                    }));
                }
                l.setGraphic((Node)v);
                l.setText(item.getName());
                v.setFitWidth((double)(DirectoryViewSkin.size(((DirectoryView)DirectoryViewSkin.this.getSkinnable()).getIconSize()) - 10));
                v.setPreserveRatio(true);
                l.setMaxHeight((double)DirectoryViewSkin.size(((DirectoryView)DirectoryViewSkin.this.getSkinnable()).getIconSize()));
                this.setGraphic((Node)l);
            } else {
                this.setGraphic(null);
            }
            super.updateItem((Object)item, empty);
        }
    }

    static class SizeCell
    extends TableCell<ResourceItem, Long> {
        private static NumberFormat BYTE_FORMAT = new DecimalFormat("#,##0 'Bytes'");
        private static NumberFormat KB_FORMAT = new DecimalFormat("#,##0 'KB'");
        private static NumberFormat MB_FORMAT = new DecimalFormat("#,##0.0 'MB'");

        public SizeCell() {
            this.setAlignment(Pos.CENTER_RIGHT);
        }

        protected void updateItem(Long item, boolean empty) {
            if (!empty) {
                if (item == null) {
                    this.setText("--");
                } else if (item >= 1000000L) {
                    this.setText(MB_FORMAT.format((double)item.longValue() / 1048576.0));
                } else if (item >= 1000L) {
                    this.setText(KB_FORMAT.format((double)item.longValue() / 1000.0));
                } else {
                    this.setText(BYTE_FORMAT.format(item));
                }
            } else {
                this.setText(null);
            }
            super.updateItem((Object)item, empty);
        }
    }
}

