/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.effects;

import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.fx.core.observable.FXObservableUtil;

public final class BoxShadow
extends Region {
    private Region node;
    private Region shadowNode;
    private static StyleablePropertyFactory<BoxShadow> FACTORY = new StyleablePropertyFactory(Region.getClassCssMetaData());
    private static CssMetaData<BoxShadow, Boolean> META_VISIBLE = FACTORY.createBooleanCssMetaData("-box-shadow-visible", n -> n.shadowVisible, false);
    private static CssMetaData<BoxShadow, Number> META_H_OFFSET = FACTORY.createSizeCssMetaData("-box-h-offset", n -> n.hOffset, (Number)0.0);
    private static CssMetaData<BoxShadow, Number> META_V_OFFSET = FACTORY.createSizeCssMetaData("-box-v-offset", n -> n.vOffset, (Number)0.0);
    private static CssMetaData<BoxShadow, Number> META_BLUR = FACTORY.createSizeCssMetaData("-box-blur", n -> n.blur, (Number)10.0);
    private static CssMetaData<BoxShadow, Number> META_SPREAD = FACTORY.createSizeCssMetaData("-box-spread", n -> n.spread, (Number)0.0);
    private static CssMetaData<BoxShadow, Color> META_COLOR = FACTORY.createColorCssMetaData("-box-color", n -> n.color, Color.BLACK);
    private StyleableBooleanProperty shadowVisible = new SimpleStyleableBooleanProperty(META_VISIBLE, (Object)this, "shadowVisible", false);
    private StyleableDoubleProperty hOffset = new SimpleStyleableDoubleProperty(META_H_OFFSET, (Object)this, "hOffset", Double.valueOf(0.0));
    private StyleableDoubleProperty vOffset = new SimpleStyleableDoubleProperty(META_V_OFFSET, (Object)this, "hOffset", Double.valueOf(0.0));
    private StyleableDoubleProperty blur = new SimpleStyleableDoubleProperty(META_BLUR, (Object)this, "blur", Double.valueOf(10.0));
    private StyleableDoubleProperty spread = new SimpleStyleableDoubleProperty(META_SPREAD, (Object)this, "spread", Double.valueOf(0.0));
    private StyleableObjectProperty<Color> color = new SimpleStyleableObjectProperty(META_COLOR, (Object)this, "color", (Object)Color.BLACK);

    public BoxShadow(Region node) {
        this.getStyleClass().add((Object)"box-shadow");
        this.node = node;
        this.shadowNode = new Region();
        this.shadowNode.getStyleClass().add((Object)"shadow-node");
        DropShadow s = new DropShadow();
        s.setBlurType(BlurType.GAUSSIAN);
        s.colorProperty().bind(this.color);
        s.radiusProperty().bind((ObservableValue)this.blur);
        this.shadowNode.setEffect((Effect)s);
        this.shadowNode.visibleProperty().bind((ObservableValue)this.shadowVisible);
        this.shadowNode.translateXProperty().bind((ObservableValue)this.hOffset);
        this.shadowNode.translateYProperty().bind((ObservableValue)this.vOffset);
        this.getChildren().addAll((Object[])new Node[]{this.shadowNode, node});
        FXObservableUtil.onChange((ObservableValue)this.node.backgroundProperty(), this::handleBackgroundChange);
        this.handleBackgroundChange(node.getBackground());
    }

    private void handleBackgroundChange(Background background) {
        CornerRadii radii;
        Background newBackground = new Background(new BackgroundFill[]{new BackgroundFill((Paint)new Color(1.0, 1.0, 1.0, 0.1), CornerRadii.EMPTY, Insets.EMPTY)});
        if (background != null && !background.getFills().isEmpty() && (radii = ((BackgroundFill)background.getFills().get(0)).getRadii()) != null) {
            newBackground = new Background(new BackgroundFill[]{new BackgroundFill((Paint)new Color(1.0, 1.0, 1.0, 0.1), radii, Insets.EMPTY)});
        }
        this.shadowNode.setBackground(newBackground);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    protected double computeMinWidth(double height) {
        return this.node.minWidth(height);
    }

    protected double computeMinHeight(double width) {
        return this.node.minHeight(width);
    }

    protected double computePrefHeight(double width) {
        return this.node.prefHeight(width);
    }

    protected double computePrefWidth(double height) {
        return this.node.prefWidth(height);
    }

    protected double computeMaxHeight(double width) {
        return this.node.maxHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return this.node.maxWidth(height);
    }

    protected void layoutChildren() {
        this.node.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
        double d = this.spread.get() * -1.0;
        this.shadowNode.resizeRelocate(d, d, this.getWidth() - d * 2.0, this.getHeight() - d * 2.0);
    }

    public String toString() {
        return "BoxShadow [hOffset=" + String.valueOf(this.hOffset) + ", vOffset=" + String.valueOf(this.vOffset) + ", blur=" + String.valueOf(this.blur) + ", spread=" + String.valueOf(this.spread) + ", color=" + String.valueOf(this.color) + "]";
    }
}

