/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.fx.code.editor.configuration.Check;
import org.eclipse.fx.code.editor.configuration.Condition;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.TokenScanner;
import org.eclipse.fx.code.editor.configuration.TokenScanner_CharacterRule;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;
import org.eclipse.fx.code.editor.configuration.gson.GsonElementFactory;

public final class GsonTokenScanner_CharacterRuleImpl
implements GsonBase,
TokenScanner_CharacterRule,
TokenScanner {
    private final List<String> characterList;
    private final Check check;
    private final Condition condition;

    public GsonTokenScanner_CharacterRuleImpl(JsonObject jsonObject) {
        this.characterList = jsonObject.has("characterList") ? Collections.unmodifiableList(StreamSupport.stream(jsonObject.getAsJsonArray("characterList").spliterator(), false).map(e -> e.getAsString()).collect(Collectors.toList())) : Collections.emptyList();
        this.check = jsonObject.has("check") ? GsonElementFactory.createCheck(jsonObject.getAsJsonObject("check")) : null;
        this.condition = jsonObject.has("condition") ? GsonElementFactory.createCondition(jsonObject.getAsJsonObject("condition")) : null;
    }

    public GsonTokenScanner_CharacterRuleImpl(List<String> characterList, Check check, Condition condition) {
        this.characterList = characterList;
        this.check = check;
        this.condition = condition;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "TokenScanner_CharacterRule");
        o.add("characterList", (JsonElement)GsonBase.toJsonArray(this.getCharacterList().stream().map(JsonPrimitive::new).collect(Collectors.toList())));
        o.add("check", this.getCheck() == null ? null : ((GsonBase)((Object)this.getCheck())).toJSONObject());
        o.add("condition", this.getCondition() == null ? null : ((GsonBase)((Object)this.getCondition())).toJSONObject());
        return o;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " { characterList : " + String.valueOf(this.characterList) + ", check : " + (this.check == null ? null : this.check.getClass().getSimpleName() + "@" + Integer.toHexString(this.check.hashCode())) + ", condition : " + (this.condition == null ? null : this.condition.getClass().getSimpleName() + "@" + Integer.toHexString(this.condition.hashCode())) + " }";
    }

    @Override
    public List<String> getCharacterList() {
        return this.characterList;
    }

    @Override
    public Check getCheck() {
        return this.check;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    public static class Builder
    implements TokenScanner_CharacterRule.Builder {
        private final EditorGModel instance;
        private final List<String> characterList = new ArrayList<String>();
        private Check check;
        private Condition condition;

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder characterList(List<String> characterList) {
            this.characterList.addAll(characterList);
            return this;
        }

        @Override
        public Builder appendCharacterList(String characterList) {
            this.characterList.add(characterList);
            return this;
        }

        @Override
        public Builder check(Check check) {
            this.check = check;
            return this;
        }

        @Override
        public Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public TokenScanner_CharacterRule build() {
            return new GsonTokenScanner_CharacterRuleImpl(this.characterList, this.check, this.condition);
        }
    }
}

