/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.client.handler;

import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import servlet.tck.common.client.handler.Handler;
import servlet.tck.common.request.Header;

public class DefaultHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHandler.class);
    private static Handler handler = new DefaultHandler();

    private DefaultHandler() {
    }

    public static Handler getInstance() {
        return handler;
    }

    @Override
    public boolean invoke(Header configuredHeader, Header responseHeader) {
        LOGGER.trace("[DefaulHandler] DefaultHandler invoked.");
        return this.areHeadersEqual(configuredHeader, responseHeader);
    }

    protected boolean areHeadersEqual(Header h1, Header h2) {
        List<String> h1Values = h1.getValues();
        List<String> h2Values = h2.getValues();
        Collections.sort(h1Values);
        Collections.sort(h2Values);
        if (h1Values.size() == h2Values.size()) {
            for (String h1Value : h1Values) {
                boolean found = false;
                for (String h2Value : h2Values) {
                    if (!h1Value.equals(h2Value)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

