/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.tldres;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.spec.tldres.HSListenerMetaInf;
import ee.jakarta.tck.pages.spec.tldres.HSListenerMetaInfSub;
import ee.jakarta.tck.pages.spec.tldres.HSListenerWebInf;
import ee.jakarta.tck.pages.spec.tldres.HSListenerWebInfSub;
import ee.jakarta.tck.pages.spec.tldres.Multi1Tag;
import ee.jakarta.tck.pages.spec.tldres.Multi2Tag;
import ee.jakarta.tck.pages.spec.tldres.Tld11Tag;
import ee.jakarta.tck.pages.spec.tldres.UriTag;
import ee.jakarta.tck.pages.spec.tldres.WebXmlTag;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_tldres_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_tldres_web.war");
        archive.addClasses(new Class[]{HSListenerWebInf.class, HSListenerWebInfSub.class, UriTag.class, WebXmlTag.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_tldres_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/sub/webinfsub.tld", "sub/webinfsub.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tlds/uri.tld", "tlds/uri.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/webinfpres.tld", "webinfpres.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/webxml.tld", "webxml.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/a12.tld", "a12.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/listenerTldTest.jsp")), "listenerTldTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeJSPPrefix.jsp")), "negativeJSPPrefix.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeTaglibAfterActionTest.jsp")), "negativeTaglibAfterActionTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/path/TldResPathRelativeUriTest.jsp")), "path/TldResPathRelativeUriTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/tld12DefaultBodyContent.jsp")), "tld12DefaultBodyContent.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TldExplicitWebXmlPrecedenceTest.jsp")), "TldExplicitWebXmlPrecedenceTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TldResPath11Test.jsp")), "TldResPath11Test.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TldResPathAbsUriNotFoundTest.jsp")), "TldResPathAbsUriNotFoundTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TldResPathDirectTldReferenceTest.jsp")), "TldResPathDirectTldReferenceTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TldResPathExplicitWebXmlTest.jsp")), "TldResPathExplicitWebXmlTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TldResPathMultiTldTest.jsp")), "TldResPathMultiTldTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TldResPathWebInfUriTest.jsp")), "TldResPathWebInfUriTest.jsp");
        JavaArchive jsp11taglibJar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jsp11taglib.jar");
        jsp11taglibJar.addAsResource((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/taglib.tld")), "META-INF/taglib.tld");
        jsp11taglibJar.addClass(Tld11Tag.class);
        archive.addAsLibrary((Archive)jsp11taglibJar);
        JavaArchive multitaglibJar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"multitaglib.jar");
        multitaglibJar.addAsResource((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/multi1.tld")), "META-INF/multi1.tld");
        multitaglibJar.addAsResource((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/jartagpres.tld")), "META-INF/jartagpres.tld");
        multitaglibJar.addAsResource((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/metainfsub.tld")), "META-INF/sub/metainfsub.tld");
        multitaglibJar.addAsResource((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/multi2.tld")), "META-INF/tlds/multi2.tld");
        multitaglibJar.addClasses(new Class[]{HSListenerMetaInf.class, HSListenerMetaInfSub.class, Multi1Tag.class, Multi2Tag.class});
        archive.addAsLibrary((Archive)multitaglibJar);
        return archive;
    }

    @Test
    public void tldResourcePathJsp11Test() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tldres_web/TldResPath11Test.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Tld11Tag: Test PASSED");
        this.invoke();
    }

    @Test
    public void tldResourcePathMultiTldJarTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tldres_web/TldResPathMultiTldTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Multi1Tag: Test PASSED|Multi2Tag: Test PASSED");
        this.invoke();
    }

    @Test
    public void tldResourcePathWebInfUriTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tldres_web/TldResPathWebInfUriTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "UriTag: Test PASSED");
        this.invoke();
    }

    @Test
    public void tldResourcePathWebXmlTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tldres_web/TldResPathExplicitWebXmlTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "WebXmlTag: Test PASSED");
        this.invoke();
    }

    @Test
    public void tldResourcePathDirectTldReference() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tldres_web/TldResPathDirectTldReferenceTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "WebXmlTag: Test PASSED");
        this.invoke();
    }

    @Test
    public void tldExplicitWebXmlPrecedenceTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tldres_web/TldExplicitWebXmlPrecedenceTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "WebXmlTag: Test PASSED");
        this.invoke();
    }

    @Test
    public void tldResPathRelativeUriTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tldres_web/path/TldResPathRelativeUriTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "WebXmlTag: Test PASSED");
        this.invoke();
    }

    @Test
    public void tldResPathAbsUriNotFoundTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tldres_web/TldResPathAbsUriNotFoundTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void tld12DefaultBodyContentTest() throws Exception {
        String testName = "tld12DefaultBodyContent";
        TEST_PROPS.setProperty("request", "GET /jsp_tldres_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void negativeJSPPrefixTest() throws Exception {
        String testName = "negativeJSPPrefix";
        TEST_PROPS.setProperty("testname", testName);
        TEST_PROPS.setProperty("request", "GET /jsp_tldres_web/" + testName + ".jsp HTTP/1.0");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void listenerTldTest() throws Exception {
        String testName = "listenerTldTest";
        TEST_PROPS.setProperty("request", "GET /jsp_tldres_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "session created meta inf.|session created meta inf sub.|session created web inf.|session created web inf sub.");
        this.invoke();
    }

    @Test
    public void negativeTaglibAfterActionTest() throws Exception {
        String testName = "negativeTaglibAfterActionTest";
        TEST_PROPS.setProperty("request", "GET /jsp_tldres_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }
}

