/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.core_syntax.actions.element;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_core_act_element_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_core_act_element_web.war");
        archive.addClasses(new Class[]{JspTestUtil.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_core_act_element_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/NameAttrTag.tag", "tags/NameAttrTag.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspElementTag.tag", "tags/JspElementTag.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspElementJspBodyTag.tag", "tags/JspElementJspBodyTag.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspElementJspAttributeTag.tag", "tags/JspElementJspAttributeTag.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspElementDynAttrTag.tag", "tags/JspElementDynAttrTag.tag");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementTest3.jsp")), "JspElementTest3.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementTest2.jspx")), "JspElementTest2.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementTest1.jsp")), "JspElementTest1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementNameReqAttributeTest3.jsp")), "JspElementNameReqAttributeTest3.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementNameReqAttributeTest2.jspx")), "JspElementNameReqAttributeTest2.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementNameReqAttributeTest1.jsp")), "JspElementNameReqAttributeTest1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementJspBodyTest3.jsp")), "JspElementJspBodyTest3.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementJspBodyTest2.jspx")), "JspElementJspBodyTest2.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementJspBodyTest1.jsp")), "JspElementJspBodyTest1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementJspAttributeTest3.jsp")), "JspElementJspAttributeTest3.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementJspAttributeTest2.jspx")), "JspElementJspAttributeTest2.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementJspAttributeTest1.jsp")), "JspElementJspAttributeTest1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementDynamicAttributeTest3.jsp")), "JspElementDynamicAttributeTest3.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementDynamicAttributeTest2.jspx")), "JspElementDynamicAttributeTest2.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspElementDynamicAttributeTest1.jsp")), "JspElementDynamicAttributeTest1.jsp");
        return archive;
    }

    @Test
    public void jspElementTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<element1>|body1|</element1>");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementTest2.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<element1>|body1|</element1>");
        TEST_PROPS.setProperty("unexpected_response_match", "xmlns:jsp|http://java.sun.com/JSP/Page");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementTest3.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<element1>|body1|</element1>");
        this.invoke();
    }

    @Test
    public void jspElementJspAttributeTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementJspAttributeTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<element1 attr1=|value1");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementJspAttributeTest2.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<element1 attr1=|value1");
        TEST_PROPS.setProperty("unexpected_response_match", "http://java.sun.com/JSP/Page");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementJspAttributeTest3.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<element1 attr1=|value1");
        this.invoke();
    }

    @Test
    public void jspElementJspBodyTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementJspBodyTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<element1>|body1|</element1>");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementJspBodyTest2.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<element1>|body1|</element1>");
        TEST_PROPS.setProperty("unexpected_response_match", "http://java.sun.com/JSP/Page");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementJspBodyTest3.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<element1>|body1|</element1>");
        this.invoke();
    }

    @Test
    public void jspElementNameReqAttributeTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementNameReqAttributeTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementNameReqAttributeTest2.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementNameReqAttributeTest3.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void jspElementDynamicAttributeTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementDynamicAttributeTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<element1>|body1|</element1>|<element2>|body2|</element2>");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementDynamicAttributeTest2.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<element1>|body1|</element1>|<element2>|body2|</element2>");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_element_web/JspElementDynamicAttributeTest3.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<element1>|body1|</element1>|<element2>|body2|</element2>");
        this.invoke();
    }
}

