/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.client.http;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpUriRequest;

public class HttpResponse {
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String CONTENT_TYPE = "Content-Type";
    private HttpUriRequest _request = null;
    private org.apache.http.HttpResponse _response = null;
    private String _encoding = "ISO-8859-1";
    private byte[] _responseBody = null;
    private String _host = null;
    private int _port;
    private boolean _isSecure;

    public HttpResponse(String host, int port, boolean isSecure, HttpUriRequest request, org.apache.http.HttpResponse response) {
        this._host = host;
        this._port = port;
        this._isSecure = isSecure;
        this._request = request;
        this._response = response;
    }

    public String getStatusCode() {
        return Integer.toString(this._response.getStatusLine().getStatusCode());
    }

    public String getReasonPhrase() {
        return this._response.getStatusLine().getReasonPhrase();
    }

    public Header[] getResponseHeaders() {
        return this._response.getAllHeaders();
    }

    public Header[] getResponseHeaders(String headerName) {
        return this._response.getHeaders(headerName);
    }

    public Header getResponseHeader(String headerName) {
        return this._response.getFirstHeader(headerName);
    }

    public byte[] getResponseBodyAsBytes() throws IOException {
        return this.getResponseBytes();
    }

    public String getResponseBodyAsString() throws IOException {
        return new String(this.getResponseBytes(), this.getResponseEncoding());
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        return new ByteArrayInputStream(this.getResponseBytes());
    }

    public String getResponseEncoding() {
        String headerVal;
        int idx;
        Header content = this._response.getFirstHeader(CONTENT_TYPE);
        if (content != null && (idx = (headerVal = content.getValue()).indexOf(";charset=")) > -1) {
            this._encoding = headerVal.substring(idx + 9);
        }
        return this._encoding;
    }

    public String toString() {
        Object resBody;
        StringBuffer sb = new StringBuffer(255);
        sb.append("[RESPONSE STATUS LINE] -> ");
        sb.append(this._response.getStatusLine().getProtocolVersion()).append(' ');
        sb.append(this._response.getStatusLine().getStatusCode()).append(' ');
        sb.append(this._response.getStatusLine().getReasonPhrase()).append('\n');
        Header[] headers = this._response.getAllHeaders();
        if (headers != null && headers.length != 0) {
            for (int i = 0; i < headers.length; ++i) {
                sb.append("       [RESPONSE HEADER] -> ");
                sb.append(headers[i].toString()).append('\n');
            }
        }
        try {
            resBody = this.getResponseBodyAsString();
        }
        catch (IOException ioe) {
            resBody = "UNEXECTED EXCEPTION: " + ioe.toString();
        }
        if (resBody != null && ((String)resBody).length() != 0) {
            sb.append("------ [RESPONSE BODY] ------\n");
            sb.append((String)resBody);
            sb.append("\n-----------------------------\n\n");
        }
        return sb.toString();
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getProtocol() {
        return this._isSecure ? "https" : "http";
    }

    public String getPath() {
        try {
            return this._request.getURI().getPath();
        }
        catch (Exception e) {
            return "";
        }
    }

    private byte[] getResponseBytes() throws IOException {
        if (this._responseBody == null) {
            if (this._response.getEntity() != null) {
                BufferedInputStream bis = new BufferedInputStream(this._response.getEntity().getContent());
                this._responseBody = bis.readAllBytes();
            } else {
                this._responseBody = null;
            }
        }
        return this._responseBody;
    }
}

