/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.client;

import ee.jakarta.tck.pages.common.client.TestCase;
import ee.jakarta.tck.pages.common.client.http.HttpRequest;
import ee.jakarta.tck.pages.common.client.http.HttpResponse;
import ee.jakarta.tck.pages.common.client.validation.ValidationFactory;
import ee.jakarta.tck.pages.common.client.validation.ValidationStrategy;
import ee.jakarta.tck.pages.common.client.validation.WebValidatorBase;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class WebTestCase
implements TestCase {
    private static final Logger LOGGER = Logger.getLogger(WebTestCase.class.getName());
    public static final String BASED_STRATEGY = WebValidatorBase.class.getName();
    private HttpRequest _request = null;
    private HttpResponse _response = null;
    private Map<String, Header> _expected = null;
    private Map<String, Header> _unexpected = null;
    private String _statusCode = null;
    private String _reasonPhrase = null;
    private String _goldenfilePath = null;
    private InputStream _goldenfileStream = null;
    private List<String> _searchStrings = null;
    private List<String> _searchStringsNoCase = null;
    private List<String> _unorderedSearchStrings = null;
    private List<String> _uSearchStrings = null;
    private boolean _expectResponseBody = true;
    private ValidationStrategy _strategy = ValidationFactory.getInstance(BASED_STRATEGY);
    private String _name = "Test Case";

    @Override
    public void execute() throws Exception {
        if (this._request == null) {
            throw new IllegalStateException("[FATAL] HttpRequest is null.");
        }
        if (this._strategy == null) {
            throw new IllegalStateException("[FATAL] No Validator available.");
        }
        try {
            this._response = this._request.execute();
        }
        catch (Throwable t) {
            String message = t.getMessage();
            throw new Exception("[FATAL] Unexpected failure during test execution." + (message == null ? t.toString() : message), t);
        }
        if (!this._strategy.validate(this)) {
            throw new Exception("Test FAILED!");
        }
    }

    public void setExpectedStatusCode(String statusCode) {
        this._statusCode = statusCode;
    }

    public void setExpectedReasonPhrase(String reasonPhrase) {
        this._reasonPhrase = reasonPhrase;
    }

    public void addExpectedHeader(String header) {
        if (this._expected == null) {
            this._expected = new HashMap<String, Header>();
        }
        this.addHeader(this._expected, header);
    }

    public void setGoldenFilePath(String gfPath) {
        this._goldenfilePath = gfPath;
    }

    public void setGoldenFileStream(InputStream in) {
        this._goldenfileStream = in;
    }

    public void setRequest(HttpRequest request) {
        this._request = request;
    }

    public void addUnexpectedHeader(String header) {
        if (this._unexpected == null) {
            this._unexpected = new HashMap<String, Header>();
        }
        this.addHeader(this._unexpected, header);
    }

    public void setAssertNoResponseBody(boolean value) {
    }

    public void setResponseSearchString(String searchString) {
        if (this._searchStrings == null) {
            this._searchStrings = new ArrayList<String>();
        }
        this.addSearchStrings(this._searchStrings, searchString);
    }

    public void setResponseSearchStringIgnoreCase(String searchString) {
        if (this._searchStringsNoCase == null) {
            this._searchStringsNoCase = new ArrayList<String>();
        }
        this.addSearchStrings(this._searchStringsNoCase, searchString);
    }

    public void setUnexpectedResponseSearchString(String searchString) {
        if (this._uSearchStrings == null) {
            this._uSearchStrings = new ArrayList<String>();
        }
        this.addSearchStrings(this._uSearchStrings, searchString);
    }

    public void setUnorderedSearchString(String searchString) {
        if (this._unorderedSearchStrings == null) {
            this._unorderedSearchStrings = new ArrayList<String>();
        }
        this.addSearchStrings(this._unorderedSearchStrings, searchString);
    }

    public List<String> getUnorderedSearchStrings() {
        return this._unorderedSearchStrings;
    }

    public HttpResponse getResponse() {
        return this._response;
    }

    public Header[] getExpectedHeaders() {
        if (this._expected == null) {
            return null;
        }
        return this._expected.values().toArray(new Header[this._expected.size()]);
    }

    public Header[] getUnexpectedHeaders() {
        if (this._unexpected == null) {
            return null;
        }
        return this._unexpected.values().toArray(new Header[this._unexpected.size()]);
    }

    public String getStatusCode() {
        return this._statusCode;
    }

    public String getReasonPhrase() {
        return this._reasonPhrase;
    }

    public List<String> getSearchStrings() {
        if (this._searchStrings == null) {
            return null;
        }
        return this._searchStrings;
    }

    public List<String> getSearchStringsNoCase() {
        if (this._searchStringsNoCase == null) {
            return null;
        }
        return this._searchStringsNoCase;
    }

    public List<String> getUnexpectedSearchStrings() {
        if (this._uSearchStrings == null) {
            return null;
        }
        return this._uSearchStrings;
    }

    public boolean getExpectResponseBody() {
        return this._expectResponseBody;
    }

    public HttpRequest getRequest() {
        return this._request;
    }

    public String getGoldenfilePath() {
        return this._goldenfilePath;
    }

    public InputStream getGoldenfileStream() {
        return this._goldenfileStream;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setStrategy(String validator) {
        ValidationStrategy strat = ValidationFactory.getInstance(validator);
        if (strat != null) {
            this._strategy = strat;
        } else {
            LOGGER.warning("An attempt was made to use a non-existing validator (" + validator + ").  Falling back to the TokenizedValidator");
        }
    }

    public String getStrategy() {
        return this._strategy.getClass().getName();
    }

    private void addHeader(Map<String, Header> map, String headerString) {
        LOGGER.fine("[WebTestCase] addHeader utility method called: " + headerString);
        StringTokenizer st = new StringTokenizer(headerString, "|");
        while (st.hasMoreTokens()) {
            String head = st.nextToken();
            int colIdx = head.indexOf(58);
            String name = head.substring(0, colIdx).trim();
            String value = head.substring(colIdx + 1).trim();
            LOGGER.fine("[WebTestCase] Adding test header: " + name + ", " + value);
            Header header = map.get(name);
            if (header != null) {
                map.put(name, this.createNewHeader(value, header));
                continue;
            }
            map.put(name, (Header)new BasicHeader(name, value));
        }
    }

    private Header createNewHeader(String newValue, Header header) {
        String oldValue = header.getValue();
        return new BasicHeader(header.getName(), oldValue + ", " + newValue);
    }

    private void addSearchStrings(List<String> stringList, String s) {
        StringTokenizer st = new StringTokenizer(s, "|");
        while (st.hasMoreTokens()) {
            stringList.add(st.nextToken());
        }
    }
}

