/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.pagedata;

import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.pagedata.PageDataValidator;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.pagedata.TagFilePageDataValidator;
import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.tags.tck.SimpleTag;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_pagedata_web.war");
        archive.addClasses(new Class[]{PageDataValidator.class, TagFilePageDataValidator.class, JspTestUtil.class, SimpleTag.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_pagedata_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/pagedata.tld", "pagedata.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/pagedatatagfile.tld", "pagedatatagfile.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/pageDataTagFileTest.tag", "tags/pageDataTagFileTest.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/template.txt", "tags/template.txt");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/PageDataTagFileTest.jsp")), "PageDataTagFileTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/PageDataTest.jsp")), "PageDataTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/template.txt")), "template.txt");
        return archive;
    }

    @Test
    public void pageDataTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_pagedata_web/PageDataTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        TEST_PROPS.setProperty("search_string", "Validator Called|Expression Text|Included template text");
        this.invoke();
    }

    @Test
    public void pageDataTagFileTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_pagedata_web/PageDataTagFileTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        TEST_PROPS.setProperty("search_string", "Validator Called|Expression Text in tag file|Included template text in tag file");
        this.invoke();
    }
}

