/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.bidironexmany;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.bidironexmany.BiDir1XMPerson;
import ee.jakarta.tck.persistence.core.relationship.bidironexmany.BiDir1XMProject;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void biDir1XMTest1() throws Exception {
        this.logTrace("Begin BiDir1X1Test1");
        boolean pass = false;
        try {
            BiDir1XMProject newProject2;
            this.getEntityTransaction().begin();
            BiDir1XMProject project1 = new BiDir1XMProject(1L, "JavaEE", Float.valueOf(500.0f));
            BiDir1XMProject project2 = new BiDir1XMProject(2L, "Identity", Float.valueOf(500.0f));
            BiDir1XMPerson person = new BiDir1XMPerson(1L, "Duke");
            this.logTrace("persisted Person Entity");
            Vector<BiDir1XMProject> projects = new Vector<BiDir1XMProject>();
            projects.add(project1);
            projects.add(project2);
            this.logTrace("set Projects to Person");
            person.setProjects(projects);
            this.logTrace("set Person to Projects");
            project1.setBiDir1XMPerson(person);
            project2.setBiDir1XMPerson(person);
            this.getEntityManager().persist((Object)person);
            this.logTrace("persisted Person Entity");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            boolean pass1 = false;
            boolean pass2 = false;
            BiDir1XMProject newProject1 = (BiDir1XMProject)this.getEntityManager().find(BiDir1XMProject.class, (Object)1L);
            if (newProject1 != null) {
                if (newProject1.getName().equals("JavaEE")) {
                    BiDir1XMPerson newPerson = newProject1.getBiDir1XMPerson();
                    if (newPerson != null) {
                        if (newPerson.getName().equals("Duke")) {
                            this.logTrace("Found Expected Person Entity");
                            pass1 = true;
                        }
                    } else {
                        this.logTrace("searched Person not Found");
                    }
                }
            } else {
                this.logTrace("searched Project not Found");
            }
            if ((newProject2 = (BiDir1XMProject)this.getEntityManager().find(BiDir1XMProject.class, (Object)2L)) != null) {
                if (newProject2.getName().equals("Identity")) {
                    BiDir1XMPerson newPerson = newProject2.getBiDir1XMPerson();
                    if (newPerson != null) {
                        if (newPerson.getName().equals("Duke")) {
                            this.logTrace("Found Expected Person Entity");
                            pass2 = true;
                        }
                    } else {
                        this.logTrace("searched Person not Found");
                    }
                }
            } else {
                this.logTrace("searched Project not Found");
            }
            if (pass1 && pass2) {
                this.logTrace("biDir1X1Test1: Expected results received");
                pass = true;
            } else {
                this.logErr("Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("biDir1XMTest1 failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIR1XMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIR1XMPERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

