/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.resultSet.resultSet17;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class resultSetClient17
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.resultSet.resultSet17";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private DataSource ds1 = null;
    private String drManager = null;
    private String sqlStmt = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private Properties props = null;
    private Properties sqlp = null;
    private ResultSet oRes = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        resultSetClient17 theTests = new resultSetClient17();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.rsSch = new rsSchema();
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort61() throws Exception {
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Decimal_Tab_Max_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            BigDecimal oSuppVal = new BigDecimal(sSuppVal);
            this.pstmt.setBigDecimal(1, oSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Decimal_Query_Max", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getShort Method");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            this.msg.setMsg("get the Maximum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Maximum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort63() throws Exception {
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(NullValue)");
            this.msg.setMsg("get the Null value from the table using getShort Method");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getShort method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the value zero", "test getShort Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort64() throws Exception {
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Numeric_Tab_Max_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            BigDecimal oSuppVal = new BigDecimal(sSuppVal);
            this.pstmt.setBigDecimal(1, oSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Numeric_Query_Max", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getShort Method");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            this.msg.setMsg("get the Maximum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Maximum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort66() throws Exception {
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(NullValue)");
            this.msg.setMsg("get the Null value from the table using getShort Method");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getShort method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the value zero", "test getShort Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort70() throws Exception {
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Char_Tab_Name_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            this.pstmt.setString(1, sSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Char_Query_Name", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getShort Method");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            this.msg.setMsg("get the Maximum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Maximum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort71() throws Exception {
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Char_Tab_Name_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            this.pstmt.setString(1, sSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Char_Query_Name", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getShort Method");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            this.msg.setMsg("get the Minimum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Minimum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort72() throws Exception {
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Char_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(NullValue)");
            this.msg.setMsg("get the Null value from the table using getShort Method");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getShort method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the value zero", "test getShort Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort73() throws Exception {
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Varchar_Tab_Name_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            this.pstmt.setString(1, sSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Varchar_Query_Name", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getShort Method");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            this.msg.setMsg("get the Maximum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Maximum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort74() throws Exception {
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Varchar_Tab_Name_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            this.pstmt.setString(1, sSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Varchar_Query_Name", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getShort Method");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            this.msg.setMsg("get the Minimum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Minimum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort75() throws Exception {
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(NullValue)");
            this.msg.setMsg("get the Null value from the table using getShort Method");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getShort method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the value zero", "test getShort Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.stmt.close();
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

