/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.packaging.installedLibrary;

import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.testng.Assert;

public abstract class AssertBean {
    @Inject
    @Any
    Instance<Object> instance;
    @Inject
    BeanManager beanManager;

    public <T> void assertUnsatisfied(Class<T> beanType, Annotation ... qualifiers) {
        Assert.assertEquals((int)this.beanManager.getBeans(beanType, qualifiers).size(), (int)0);
        Instance subtypeInstance = this.instance.select(beanType, qualifiers);
        Assert.assertTrue((boolean)subtypeInstance.isUnsatisfied());
    }

    public <T> void assertAmbiguous(Class<T> beanType, Annotation ... qualifiers) {
        try {
            this.beanManager.resolve(this.beanManager.getBeans(beanType, qualifiers));
            Assert.fail((String)"AmbiguousResolutionException not thrown");
        }
        catch (AmbiguousResolutionException ambiguousResolutionException) {
            // empty catch block
        }
        Instance subtypeInstance = this.instance.select(beanType, qualifiers);
        Assert.assertTrue((boolean)subtypeInstance.isAmbiguous());
    }

    public <T> T assertAvailable(Class<T> beanType, Annotation ... qualifiers) {
        Assert.assertNotNull((Object)this.beanManager.resolve(this.beanManager.getBeans(beanType, qualifiers)));
        Instance beanTypeInstance = this.instance.select(beanType, qualifiers);
        Object beanInstance = beanTypeInstance.get();
        Assert.assertNotNull((Object)beanInstance);
        return (T)beanInstance;
    }
}

