/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.ejb;

import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.transaction.UserTransaction;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.logging.ValidatorLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.PlugableValidator;
import org.jboss.weld.util.reflection.Formats;

class WeldEjbValidator
implements PlugableValidator {
    WeldEjbValidator() {
    }

    @Override
    public void validateInjectionPointForDefinitionErrors(InjectionPoint ij, Bean<?> bean, BeanManagerImpl beanManager) {
        if (bean instanceof SessionBean) {
            SessionBean sessionBean = (SessionBean)bean;
            if (UserTransaction.class.equals((Object)ij.getType()) && (ij.getQualifiers().isEmpty() || ij.getQualifiers().contains(Default.Literal.INSTANCE)) && this.hasContainerManagedTransactions(sessionBean)) {
                throw ValidatorLogger.LOG.userTransactionInjectionIntoBeanWithContainerManagedTransactions(ij, Formats.formatAsStackTraceElement(ij));
            }
        }
    }

    private boolean hasContainerManagedTransactions(SessionBean<?> bean) {
        TransactionManagement transactionManagementAnnotation = (TransactionManagement)bean.getAnnotated().getAnnotation(TransactionManagement.class);
        if (transactionManagementAnnotation == null) {
            return true;
        }
        return transactionManagementAnnotation.value() == TransactionManagementType.CONTAINER;
    }
}

