/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AccessPathImpl;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class HashTableNode
extends SingleChildResultSetNode {
    PredicateList searchPredicateList;
    PredicateList joinPredicateList;
    SubqueryList pSubqueryList;
    SubqueryList rSubqueryList;

    HashTableNode(ResultSetNode resultSetNode, Properties properties, ResultColumnList resultColumnList, PredicateList predicateList, PredicateList predicateList2, AccessPathImpl accessPathImpl, CostEstimate costEstimate, SubqueryList subqueryList, SubqueryList subqueryList2, int[] nArray, ContextManager contextManager) {
        super(resultSetNode, properties, contextManager);
        this.setResultColumns(resultColumnList);
        this.searchPredicateList = predicateList;
        this.joinPredicateList = predicateList2;
        this.trulyTheBestAccessPath = accessPathImpl;
        this.setCostEstimate(costEstimate);
        this.pSubqueryList = subqueryList;
        this.rSubqueryList = subqueryList2;
        this.setHashKeyColumns(nArray);
    }

    public Optimizable modifyAccessPath(JBitSet jBitSet, Optimizer optimizer) throws StandardException {
        return this;
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.childResult instanceof FromVTI) {
            ((FromVTI)this.childResult).computeProjectionAndRestriction(this.searchPredicateList);
        }
        this.generateMinion(activationClassBuilder, methodBuilder, false);
    }

    @Override
    void generateResultSet(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateMinion(expressionClassBuilder, methodBuilder, true);
    }

    private void generateMinion(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, boolean bl) throws StandardException {
        ValueNode valueNode = null;
        Object var6_5 = null;
        this.verifyProperties(this.getDataDictionary());
        if (this.searchPredicateList != null) {
            this.searchPredicateList.removeRedundantPredicates();
            valueNode = this.searchPredicateList.restorePredicates();
            this.searchPredicateList = null;
        }
        ResultColumnList.ColumnMapping columnMapping = this.getResultColumns().mapSourceColumns();
        int[] nArray = columnMapping.mapArray;
        int n = expressionClassBuilder.addItem(new ReferencedColumnsDescriptorImpl(nArray));
        Object[] objectArray = FormatableIntHolder.getFormatableIntHolders(this.hashKeyColumns());
        FormatableArrayHolder formatableArrayHolder = new FormatableArrayHolder(objectArray);
        int n2 = expressionClassBuilder.addItem(formatableArrayHolder);
        expressionClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        if (bl) {
            this.childResult.generateResultSet(expressionClassBuilder, methodBuilder);
        } else {
            this.childResult.generate((ActivationClassBuilder)expressionClassBuilder, methodBuilder);
        }
        this.assignResultSetNumber();
        if (this.pSubqueryList != null && this.pSubqueryList.size() > 0) {
            this.pSubqueryList.setPointOfAttachment(this.getResultSetNumber());
        }
        if (this.rSubqueryList != null && this.rSubqueryList.size() > 0) {
            this.rSubqueryList.setPointOfAttachment(this.getResultSetNumber());
        }
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        if (valueNode == null) {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder methodBuilder2 = expressionClassBuilder.newUserExprFun();
            valueNode.generateExpression(expressionClassBuilder, methodBuilder2);
            methodBuilder2.methodReturn();
            methodBuilder2.complete();
            expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        }
        this.joinPredicateList.generateQualifiers(expressionClassBuilder, methodBuilder, (Optimizable)((Object)this.childResult), false);
        if (this.reflectionNeededForProjection()) {
            this.getResultColumns().generateCore(expressionClassBuilder, methodBuilder, false);
        } else {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(n);
        methodBuilder.push(this.getResultColumns().reusableResult());
        methodBuilder.push(n2);
        methodBuilder.push(false);
        methodBuilder.push(-1L);
        methodBuilder.push(this.initialCapacity);
        methodBuilder.push(this.loadFactor);
        methodBuilder.push(this.getCostEstimate().singleScanRowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getHashTableResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 14);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.searchPredicateList != null) {
            this.searchPredicateList = (PredicateList)this.searchPredicateList.accept(visitor);
        }
        if (this.joinPredicateList != null) {
            this.joinPredicateList = (PredicateList)this.joinPredicateList.accept(visitor);
        }
    }
}

