/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.jsp.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.PageContext;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ImplicitObjectELResolver
extends ELResolver {
    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null) {
            return null;
        }
        PageContext ctxt = (PageContext)context.getContext(JspContext.class);
        if ("pageContext".equals(property)) {
            context.setPropertyResolved(true);
            return ctxt;
        }
        ImplicitObjects implicitObjects = ImplicitObjects.getImplicitObjects(ctxt);
        if ("pageScope".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getPageScopeMap();
        }
        if ("requestScope".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getRequestScopeMap();
        }
        if ("sessionScope".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getSessionScopeMap();
        }
        if ("applicationScope".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getApplicationScopeMap();
        }
        if ("param".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getParamMap();
        }
        if ("paramValues".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getParamsMap();
        }
        if ("header".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getHeaderMap();
        }
        if ("headerValues".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getHeadersMap();
        }
        if ("initParam".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getInitParamMap();
        }
        if ("cookie".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getCookieMap();
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && ("pageContext".equals(property) || "pageScope".equals(property)) || "requestScope".equals(property) || "sessionScope".equals(property) || "applicationScope".equals(property) || "param".equals(property) || "paramValues".equals(property) || "header".equals(property) || "headerValues".equals(property) || "initParam".equals(property) || "cookie".equals(property)) {
            context.setPropertyResolved(true);
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object val) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && ("pageContext".equals(property) || "pageScope".equals(property)) || "requestScope".equals(property) || "sessionScope".equals(property) || "applicationScope".equals(property) || "param".equals(property) || "paramValues".equals(property) || "header".equals(property) || "headerValues".equals(property) || "initParam".equals(property) || "cookie".equals(property)) {
            throw new PropertyNotWritableException();
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && ("pageContext".equals(property) || "pageScope".equals(property)) || "requestScope".equals(property) || "sessionScope".equals(property) || "applicationScope".equals(property) || "param".equals(property) || "paramValues".equals(property) || "header".equals(property) || "headerValues".equals(property) || "initParam".equals(property) || "cookie".equals(property)) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="JSP 3.1")
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>(11);
        FeatureDescriptor descriptor = new FeatureDescriptor();
        descriptor.setName("pageContext");
        descriptor.setDisplayName("pageContext");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", PageContext.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("pageScope");
        descriptor.setDisplayName("pageScope");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("requestScope");
        descriptor.setDisplayName("requestScope");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("sessionScope");
        descriptor.setDisplayName("sessionScope");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("applicationScope");
        descriptor.setDisplayName("applicationScope");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("param");
        descriptor.setDisplayName("param");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("paramValues");
        descriptor.setDisplayName("paramValues");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("header");
        descriptor.setDisplayName("header");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("headerValues");
        descriptor.setDisplayName("headerValues");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("cookie");
        descriptor.setDisplayName("cookie");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("initParam");
        descriptor.setDisplayName("initParam");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        return list.iterator();
    }

    public Class<String> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return String.class;
        }
        return null;
    }

    private static abstract class EnumeratedMap<K, V>
    implements Map<K, V> {
        Map<K, V> mMap;

        private EnumeratedMap() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object pKey) {
            return this.getValue(pKey) != null;
        }

        @Override
        public boolean containsValue(Object pValue) {
            return this.getAsMap().containsValue(pValue);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.getAsMap().entrySet();
        }

        @Override
        public V get(Object pKey) {
            return this.getValue(pKey);
        }

        @Override
        public boolean isEmpty() {
            return !this.enumerateKeys().hasMoreElements();
        }

        @Override
        public Set<K> keySet() {
            return this.getAsMap().keySet();
        }

        @Override
        public V put(K pKey, V pValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> pMap) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object pKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.getAsMap().size();
        }

        @Override
        public Collection<V> values() {
            return this.getAsMap().values();
        }

        public abstract Enumeration<K> enumerateKeys();

        public abstract boolean isMutable();

        public abstract V getValue(Object var1);

        public Map<K, V> getAsMap() {
            if (this.mMap != null) {
                return this.mMap;
            }
            Map<K, V> m = this.convertToMap();
            if (!this.isMutable()) {
                this.mMap = m;
            }
            return m;
        }

        Map<K, V> convertToMap() {
            HashMap<K, V> ret = new HashMap<K, V>();
            Enumeration<K> e = this.enumerateKeys();
            while (e.hasMoreElements()) {
                K key = e.nextElement();
                V value = this.getValue(key);
                ret.put(key, value);
            }
            return ret;
        }
    }

    private static class ImplicitObjects {
        static final String sAttributeName = "org.apache.taglibs.standard.ImplicitObjects";
        PageContext mContext;
        Map<String, Object> mPage;
        Map<String, Object> mRequest;
        Map<String, Object> mSession;
        Map<String, Object> mApplication;
        Map<String, String> mParam;
        Map<String, String[]> mParams;
        Map<String, String> mHeader;
        Map<String, String[]> mHeaders;
        Map<String, String> mInitParam;
        Map<String, Cookie> mCookie;

        public ImplicitObjects(PageContext pContext) {
            this.mContext = pContext;
        }

        public static ImplicitObjects getImplicitObjects(PageContext pContext) {
            ImplicitObjects objs = (ImplicitObjects)pContext.getAttribute(sAttributeName, 1);
            if (objs == null) {
                objs = new ImplicitObjects(pContext);
                pContext.setAttribute(sAttributeName, objs, 1);
            }
            return objs;
        }

        public Map<String, Object> getPageScopeMap() {
            if (this.mPage == null) {
                this.mPage = ImplicitObjects.createPageScopeMap(this.mContext);
            }
            return this.mPage;
        }

        public Map<String, Object> getRequestScopeMap() {
            if (this.mRequest == null) {
                this.mRequest = ImplicitObjects.createRequestScopeMap(this.mContext);
            }
            return this.mRequest;
        }

        public Map<String, Object> getSessionScopeMap() {
            if (this.mSession == null) {
                this.mSession = ImplicitObjects.createSessionScopeMap(this.mContext);
            }
            return this.mSession;
        }

        public Map<String, Object> getApplicationScopeMap() {
            if (this.mApplication == null) {
                this.mApplication = ImplicitObjects.createApplicationScopeMap(this.mContext);
            }
            return this.mApplication;
        }

        public Map<String, String> getParamMap() {
            if (this.mParam == null) {
                this.mParam = ImplicitObjects.createParamMap(this.mContext);
            }
            return this.mParam;
        }

        public Map<String, String[]> getParamsMap() {
            if (this.mParams == null) {
                this.mParams = ImplicitObjects.createParamsMap(this.mContext);
            }
            return this.mParams;
        }

        public Map<String, String> getHeaderMap() {
            if (this.mHeader == null) {
                this.mHeader = ImplicitObjects.createHeaderMap(this.mContext);
            }
            return this.mHeader;
        }

        public Map<String, String[]> getHeadersMap() {
            if (this.mHeaders == null) {
                this.mHeaders = ImplicitObjects.createHeadersMap(this.mContext);
            }
            return this.mHeaders;
        }

        public Map<String, String> getInitParamMap() {
            if (this.mInitParam == null) {
                this.mInitParam = ImplicitObjects.createInitParamMap(this.mContext);
            }
            return this.mInitParam;
        }

        public Map<String, Cookie> getCookieMap() {
            if (this.mCookie == null) {
                this.mCookie = ImplicitObjects.createCookieMap(this.mContext);
            }
            return this.mCookie;
        }

        public static Map<String, Object> createPageScopeMap(PageContext pContext) {
            final PageContext context = pContext;
            return new EnumeratedMap<String, Object>(){

                @Override
                public Enumeration<String> enumerateKeys() {
                    return context.getAttributeNamesInScope(1);
                }

                @Override
                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return context.getAttribute((String)pKey, 1);
                    }
                    return null;
                }

                @Override
                public boolean isMutable() {
                    return true;
                }
            };
        }

        public static Map<String, Object> createRequestScopeMap(PageContext pContext) {
            final PageContext context = pContext;
            return new EnumeratedMap<String, Object>(){

                @Override
                public Enumeration<String> enumerateKeys() {
                    return context.getAttributeNamesInScope(2);
                }

                @Override
                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return context.getAttribute((String)pKey, 2);
                    }
                    return null;
                }

                @Override
                public boolean isMutable() {
                    return true;
                }
            };
        }

        public static Map<String, Object> createSessionScopeMap(PageContext pContext) {
            final PageContext context = pContext;
            return new EnumeratedMap<String, Object>(){

                @Override
                public Enumeration<String> enumerateKeys() {
                    return context.getAttributeNamesInScope(3);
                }

                @Override
                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return context.getAttribute((String)pKey, 3);
                    }
                    return null;
                }

                @Override
                public boolean isMutable() {
                    return true;
                }
            };
        }

        public static Map<String, Object> createApplicationScopeMap(PageContext pContext) {
            final PageContext context = pContext;
            return new EnumeratedMap<String, Object>(){

                @Override
                public Enumeration<String> enumerateKeys() {
                    return context.getAttributeNamesInScope(4);
                }

                @Override
                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return context.getAttribute((String)pKey, 4);
                    }
                    return null;
                }

                @Override
                public boolean isMutable() {
                    return true;
                }
            };
        }

        public static Map<String, String> createParamMap(PageContext pContext) {
            final HttpServletRequest request = (HttpServletRequest)pContext.getRequest();
            return new EnumeratedMap<String, String>(){

                @Override
                public Enumeration<String> enumerateKeys() {
                    return request.getParameterNames();
                }

                @Override
                public String getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return request.getParameter((String)pKey);
                    }
                    return null;
                }

                @Override
                public boolean isMutable() {
                    return false;
                }
            };
        }

        public static Map<String, String[]> createParamsMap(PageContext pContext) {
            final HttpServletRequest request = (HttpServletRequest)pContext.getRequest();
            return new EnumeratedMap<String, String[]>(){

                @Override
                public Enumeration<String> enumerateKeys() {
                    return request.getParameterNames();
                }

                @Override
                public String[] getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return request.getParameterValues((String)pKey);
                    }
                    return null;
                }

                @Override
                public boolean isMutable() {
                    return false;
                }
            };
        }

        public static Map<String, String> createHeaderMap(PageContext pContext) {
            final HttpServletRequest request = (HttpServletRequest)pContext.getRequest();
            return new EnumeratedMap<String, String>(){

                @Override
                public Enumeration<String> enumerateKeys() {
                    return request.getHeaderNames();
                }

                @Override
                public String getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return request.getHeader((String)pKey);
                    }
                    return null;
                }

                @Override
                public boolean isMutable() {
                    return false;
                }
            };
        }

        public static Map<String, String[]> createHeadersMap(PageContext pContext) {
            final HttpServletRequest request = (HttpServletRequest)pContext.getRequest();
            return new EnumeratedMap<String, String[]>(){

                @Override
                public Enumeration<String> enumerateKeys() {
                    return request.getHeaderNames();
                }

                @Override
                public String[] getValue(Object pKey) {
                    if (pKey instanceof String) {
                        ArrayList<String> l = new ArrayList<String>();
                        Enumeration e = request.getHeaders((String)pKey);
                        if (e != null) {
                            while (e.hasMoreElements()) {
                                l.add((String)e.nextElement());
                            }
                        }
                        return l.toArray(new String[l.size()]);
                    }
                    return null;
                }

                @Override
                public boolean isMutable() {
                    return false;
                }
            };
        }

        public static Map<String, String> createInitParamMap(PageContext pContext) {
            final ServletContext context = pContext.getServletContext();
            return new EnumeratedMap<String, String>(){

                @Override
                public Enumeration<String> enumerateKeys() {
                    return context.getInitParameterNames();
                }

                @Override
                public String getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return context.getInitParameter((String)pKey);
                    }
                    return null;
                }

                @Override
                public boolean isMutable() {
                    return false;
                }
            };
        }

        public static Map<String, Cookie> createCookieMap(PageContext pContext) {
            HttpServletRequest request = (HttpServletRequest)pContext.getRequest();
            Cookie[] cookies = request.getCookies();
            HashMap<String, Cookie> ret = new HashMap<String, Cookie>();
            for (int i = 0; cookies != null && i < cookies.length; ++i) {
                String name;
                Cookie cookie = cookies[i];
                if (cookie == null || ret.containsKey(name = cookie.getName())) continue;
                ret.put(name, cookie);
            }
            return ret;
        }
    }
}

