/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.inbound;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ActiveOutboundResourceAdapter;
import com.sun.enterprise.connectors.inbound.ActiveInboundResourceAdapter;
import com.sun.enterprise.connectors.inbound.MessageEndpointFactoryInfo;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.ResourceAdapter;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="ActiveInboundResourceAdapter")
@PerLookup
public class ActiveInboundResourceAdapterImpl
extends ActiveOutboundResourceAdapter
implements ActiveInboundResourceAdapter {
    private Hashtable<String, MessageEndpointFactoryInfo> factories_;

    public void init(ResourceAdapter ra, ConnectorDescriptor desc, String moduleName, ClassLoader jcl) throws ConnectorRuntimeException {
        super.init(ra, desc, moduleName, jcl);
        this.factories_ = new Hashtable();
    }

    public void destroy() {
        this.deactivateEndPoints();
        super.destroy();
    }

    private void deactivateEndPoints() {
        if (this.resourceadapter_ != null) {
            for (MessageEndpointFactoryInfo element : this.getAllEndpointFactories()) {
                try {
                    this.resourceadapter_.endpointDeactivation(element.getEndpointFactory(), element.getActivationSpec());
                }
                catch (RuntimeException e) {
                    _logger.log(Level.SEVERE, "Error during endpointDeactivation ", e);
                }
            }
        }
    }

    public Collection<MessageEndpointFactoryInfo> getAllEndpointFactories() {
        return this.factories_.values();
    }

    @Override
    public MessageEndpointFactoryInfo getEndpointFactoryInfo(String id) {
        return this.factories_.get(id);
    }

    @Override
    public void updateMDBRuntimeInfo(EjbMessageBeanDescriptor descriptor_, BeanPoolDescriptor poolDescriptor) throws ConnectorRuntimeException {
    }

    @Override
    public void validateActivationSpec(ActivationSpec spec) {
    }

    public Set getAllEndpointFactoryInfo() {
        Hashtable infos = (Hashtable)this.factories_.clone();
        return infos.entrySet();
    }

    public boolean handles(ConnectorDescriptor cd, String moduleName) {
        return cd.getInBoundDefined() && !ConnectorsUtil.isJMSRA((String)moduleName);
    }

    @Override
    public void addEndpointFactoryInfo(String id, MessageEndpointFactoryInfo info) {
        this.factories_.put(id, info);
    }

    @Override
    public void removeEndpointFactoryInfo(String id) {
        this.factories_.remove(id);
    }
}

