/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.api;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.NoClusteredBroker;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import jakarta.inject.Singleton;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.cluster.api.NoClusterManager")
@Singleton
public class NoClusterManager
implements ClusterManager {
    private static boolean DEBUG = false;
    private Logger logger = Globals.getLogger();
    private boolean initialized = false;
    private ClusteredBroker localcb = null;
    private String clusterid = Globals.getClusterID();

    @Override
    public String getClusterId() {
        return this.clusterid;
    }

    @Override
    public void setMQAddress(MQAddress address) throws Exception {
        if (!this.initialized) {
            this.initialize(address);
            return;
        }
        ClusteredBroker cb = this.getLocalBroker();
        cb.setBrokerURL(address);
    }

    @Override
    public int getClusterPingInterval() {
        return 60;
    }

    @Override
    public MQAddress getMQAddress() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return this.getLocalBroker().getBrokerURL();
    }

    @Override
    public void addEventListener(ClusterListener listener) {
    }

    @Override
    public boolean removeEventListener(ClusterListener listener) {
        return true;
    }

    @Override
    public ClusteredBroker getLocalBroker() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return this.localcb;
    }

    @Override
    public int getKnownBrokerCount() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return 1;
    }

    @Override
    public int getConfigBrokerCount() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return 1;
    }

    @Override
    public int getActiveBrokerCount() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return 1;
    }

    @Override
    public Iterator getKnownBrokers(boolean refresh) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        ArrayList<ClusteredBroker> l = new ArrayList<ClusteredBroker>();
        l.add(this.localcb);
        return l.iterator();
    }

    @Override
    public Iterator getConfigBrokers() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        ArrayList<ClusteredBroker> l = new ArrayList<ClusteredBroker>();
        l.add(this.localcb);
        return l.iterator();
    }

    @Override
    public Iterator getActiveBrokers() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        ArrayList<ClusteredBroker> l = new ArrayList<ClusteredBroker>();
        l.add(this.localcb);
        return l.iterator();
    }

    @Override
    public ClusteredBroker getBroker(String brokerid) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        if (this.localcb.getBrokerName().equals(brokerid)) {
            return this.localcb;
        }
        return null;
    }

    @Override
    public String activateBroker(MQAddress URL2, UID uid, String instName, Object userData) throws BrokerException {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".activateBroker(" + String.valueOf(URL2) + " ...)");
    }

    @Override
    public String activateBroker(String brokerid, UID uid, String instName, Object userData) throws BrokerException {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".activateBroker(" + brokerid + " ...)");
    }

    @Override
    public void deactivateBroker(MQAddress URL2, Object userData) {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".deactivateBroker(" + String.valueOf(URL2) + " ...)");
    }

    @Override
    public void deactivateBroker(String brokerid, Object userData) {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".deactivateBroker(" + brokerid + " ..)");
    }

    @Override
    public String lookupBrokerID(MQAddress broker) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        MQAddress addr = this.localcb.getBrokerURL();
        if (addr.equals(broker)) {
            return this.localcb.getBrokerName();
        }
        return null;
    }

    @Override
    public String lookupStoreSessionOwner(UID uid) {
        return null;
    }

    @Override
    public String getStoreSessionCreator(UID uid) {
        return null;
    }

    @Override
    public String lookupBrokerSessionUID(UID uid) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        UID buid = this.localcb.getBrokerSessionUID();
        if (buid.equals(uid)) {
            return this.localcb.getBrokerName();
        }
        return null;
    }

    protected boolean allowMasterBroker() {
        return false;
    }

    @Override
    public ClusteredBroker getMasterBroker() {
        return null;
    }

    @Override
    public String getTransport() {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".getTransport()");
    }

    @Override
    public int getClusterPort() {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".getClusterPort()");
    }

    @Override
    public String getClusterHost() {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".getClusterHost()");
    }

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public void reloadConfig() throws BrokerException {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".reloadCluster()");
    }

    @Override
    public String initialize(MQAddress address) throws BrokerException {
        this.localcb = new NoClusteredBroker(address, new UID());
        this.localcb.setStatus(257, null);
        if (DEBUG) {
            this.logger.log(8, "ClusterManager: " + this.toString());
        }
        this.initialized = true;
        return this.localcb.getBrokerName();
    }

    public String toString() {
        return "NoClusterManager: [local=" + String.valueOf(this.localcb) + "]";
    }

    @Override
    public synchronized UID getStoreSessionUID() {
        return null;
    }

    @Override
    public synchronized UID getBrokerSessionUID() {
        return this.getLocalBroker().getBrokerSessionUID();
    }

    protected void addSupportedStoreSessionUID(UID uid) {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".addSupportedStoreSessionUID()");
    }

    @Override
    public Set getSupportedStoreSessionUIDs() {
        return new HashSet();
    }

    @Override
    public MQAddress getBrokerNextToMe() {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".getBrokerNextToMe()");
    }

    @Override
    public LinkedHashSet parseBrokerList(String values) throws MalformedURLException, UnknownHostException {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".parseBrokerList()");
    }

    @Override
    public ClusteredBroker getBrokerByNodeName(String nodeName) throws BrokerException {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".getbrokerByNodeName()");
    }

    @Override
    public void partitionAdded(UID partitionID, Object source) {
    }

    @Override
    public void partitionRemoved(UID partitionID, Object source, Object destinedTo) {
    }
}

