/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.osgi.framework.Bundle;

class Jar {
    private final URI uri;
    private final long lastModified;
    private final long bundleId;

    Jar(File file) {
        this.uri = file.toURI();
        this.lastModified = file.lastModified();
        this.bundleId = -1L;
    }

    Jar(Bundle b) throws URISyntaxException {
        String location = b.getLocation();
        this.uri = location != null && !location.equals("System Bundle") ? new URI(b.getLocation()).normalize() : null;
        this.lastModified = b.getLastModified();
        this.bundleId = b.getBundleId();
    }

    Jar(URI uri) {
        this.uri = uri.normalize();
        long localLastModified = -1L;
        this.bundleId = -1L;
        try {
            File f = new File(uri);
            localLastModified = f.lastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastModified = localLastModified;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getPath() {
        return this.uri == null ? null : this.uri.getPath();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public boolean isNewer(Jar other) {
        return this.getLastModified() > other.getLastModified();
    }

    public int hashCode() {
        return this.uri == null ? 0 : this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Jar)) {
            return false;
        }
        Jar other = (Jar)obj;
        if (this.uri == null) {
            return other.uri == null;
        }
        if (other.uri == null) {
            return false;
        }
        return this.uri.toString().equals(other.uri.toString());
    }
}

