/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.List;

public class FromTxnLogConverter {
    Store store;
    FileStore fileStore;
    Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public FromTxnLogConverter(Store store) {
        this.store = store;
    }

    public void convertFromTxnLogFormat() {
        if (DEBUG) {
            this.logger.log(4, this.getPrefix() + " convertFromTxnLogFormat");
        }
        this.fileStore = (FileStore)this.store;
        TransactionLogManager txnLogManager = this.fileStore.getTxnLogManager();
        this.convert(txnLogManager.getLocalTransactionManager(), new LocalTxnConverter());
        this.convert(txnLogManager.getClusterTransactionManager(), new ClusterTxnConverter());
        this.convert(txnLogManager.getRemoteTransactionManager(), new RemoteTxnConverter());
    }

    void convert(BaseTransactionManager baseTxnManager, TxnConverter converter) {
        if (DEBUG) {
            this.logger.log(4, this.getPrefix() + " converting trxns from TxnManager");
        }
        List<BaseTransaction> list = baseTxnManager.getAllIncompleteTransactions();
        for (BaseTransaction baseTxn : list) {
            try {
                converter.convert(baseTxn);
            }
            catch (BrokerException | IOException e) {
                this.logger.logStack(32, e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getPrefix() {
        return String.valueOf(Thread.currentThread()) + " TransactionConverter.";
    }

    static {
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
    }

    class LocalTxnConverter
    extends TxnConverter {
        LocalTxnConverter() {
        }
    }

    class TxnConverter {
        TxnConverter() {
        }

        void convert(BaseTransaction baseTxn) throws BrokerException, IOException {
            if (DEBUG) {
                FromTxnLogConverter.this.logger.log(4, FromTxnLogConverter.this.getPrefix() + " convert txn " + String.valueOf(baseTxn));
            }
            TransactionUID id = baseTxn.getTid();
            TransactionState ts = baseTxn.getTransactionState();
            ts.setState(1);
            FromTxnLogConverter.this.fileStore.storeTransaction(id, ts, true);
            TransactionWork txnWork = baseTxn.getTransactionWork();
            if (txnWork != null) {
                this.convertWork(txnWork, ts, id);
            }
            ts.setState(5);
            FromTxnLogConverter.this.fileStore.updateTransactionState(id, ts, true);
        }

        void convertWork(TransactionWork work, TransactionState ts, TransactionUID txid) throws BrokerException, IOException {
            if (DEBUG) {
                FromTxnLogConverter.this.logger.log(4, FromTxnLogConverter.this.getPrefix() + " convertWork ");
            }
            List<TransactionWorkMessage> sentMsgs = work.getSentMessages();
            for (TransactionWorkMessage msg : sentMsgs) {
                DestinationUID duid;
                if (DEBUG) {
                    FromTxnLogConverter.this.logger.log(4, FromTxnLogConverter.this.getPrefix() + " convert sent msg " + String.valueOf(msg));
                }
                int type = (duid = msg.getDestUID()).isQueue() ? 1 : 2;
                DestinationList.getDestination((PartitionedStore)FromTxnLogConverter.this.fileStore, duid.getName(), type, true, true);
                Packet message = msg.getMessage();
                FromTxnLogConverter.this.fileStore.storeMessage(duid, message, true);
            }
            List<TransactionWorkMessageAck> consumedMsgs = work.getMessageAcknowledgments();
            for (TransactionWorkMessageAck msgAck : consumedMsgs) {
                DestinationUID duid;
                if (DEBUG) {
                    FromTxnLogConverter.this.logger.log(4, FromTxnLogConverter.this.getPrefix() + " convert consumed msg " + String.valueOf(msgAck));
                }
                int type = (duid = msgAck.getDestUID()).isQueue() ? 1 : 2;
                Destination[] ds = DestinationList.getDestination((PartitionedStore)FromTxnLogConverter.this.fileStore, duid.getName(), type, true, true);
                Destination dest = ds[0];
                dest.load();
                SysMessageID mid = msgAck.getSysMessageID();
                ConsumerUID cid = msgAck.getConsumerID();
                TransactionAcknowledgement txAck = new TransactionAcknowledgement(mid, cid, cid);
                FromTxnLogConverter.this.fileStore.storeTransactionAck(txid, txAck, false);
            }
        }
    }

    class ClusterTxnConverter
    extends TxnConverter {
        ClusterTxnConverter() {
        }

        @Override
        void convert(BaseTransaction baseTxn) throws BrokerException, IOException {
            ClusterTransaction clusterTxn = (ClusterTransaction)baseTxn;
            TransactionUID id = baseTxn.getTid();
            TransactionState ts = baseTxn.getTransactionState();
            ts.setState(1);
            FromTxnLogConverter.this.fileStore.storeTransaction(id, ts, true);
            TransactionWork txnWork = baseTxn.getTransactionWork();
            if (txnWork != null) {
                this.convertWork(txnWork, ts, id);
            }
            ((PartitionedStore)((Object)FromTxnLogConverter.this.store)).updateClusterTransaction(id, clusterTxn.getTransactionBrokers(), Destination.PERSIST_SYNC);
            ts.setState(5);
            FromTxnLogConverter.this.fileStore.updateTransactionState(id, ts, true);
        }
    }

    class RemoteTxnConverter
    extends TxnConverter {
        RemoteTxnConverter() {
        }

        @Override
        void convert(BaseTransaction baseTxn) throws BrokerException, IOException {
            RemoteTransaction remoteTxn = (RemoteTransaction)baseTxn;
            TransactionUID id = baseTxn.getTid();
            TransactionState ts = baseTxn.getTransactionState();
            ((PartitionedStore)((Object)FromTxnLogConverter.this.store)).storeRemoteTransaction(id, ts, remoteTxn.getTxnAcks(), remoteTxn.getTxnHomeBroker(), Destination.PERSIST_SYNC);
        }
    }
}

