/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.unaryoperator;

import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.NameValuePair;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private final boolean[] deferred = new boolean[]{true, false};

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elNullUnaryTest() throws Exception {
        boolean pass = false;
        String[] symbols = new String[]{"$", "#"};
        Long expectedResult = Long.valueOf("0");
        try {
            for (String prefix : symbols) {
                String expr = prefix + "{-null}";
                logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
                Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult, 0);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elBigDecimalUnaryTest() throws Exception {
        boolean pass = false;
        BigDecimal bd = BigDecimal.valueOf(10.0);
        BigDecimal expectedResult = BigDecimal.valueOf(-10.0);
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(bd);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, BigDecimal.class) && ExprEval.compareValue((BigDecimal)result, expectedResult, 0);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elBigIntegerUnaryTest() throws Exception {
        boolean pass = false;
        BigInteger bi = BigInteger.valueOf(100L);
        BigInteger expectedResult = BigInteger.valueOf(-100L);
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(bi);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, BigInteger.class) && ExprEval.compareValue((BigInteger)result, expectedResult, 0);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elDoubleStringUnaryTest() throws Exception {
        boolean pass = false;
        String[] values = new String[]{"10.0", "10E0", "10e0"};
        Double expectedResult = Double.valueOf("-10");
        try {
            for (boolean tf : this.deferred) {
                for (String val : values) {
                    NameValuePair[] value = NameValuePair.buildUnaryNameValue(val);
                    String expr = ExprEval.buildElExpr(tf, "unary_minus");
                    Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                    logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                    pass = ExprEval.compareClass(result, Double.class) && ExprEval.compareValue(result, expectedResult);
                }
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elLongStringUnaryTest() throws Exception {
        boolean pass = false;
        String val = "100";
        Long expectedResult = Long.valueOf("-100");
        try {
            for (boolean tf : this.deferred) {
                NameValuePair[] value = NameValuePair.buildUnaryNameValue(val);
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue(result, expectedResult);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elByteUnaryTest() throws Exception {
        boolean pass = false;
        byte num = 1;
        byte expectedResult = -1;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(num);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Byte.class) && ExprEval.compareValue(result, expectedResult);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elShortUnaryTest() throws Exception {
        boolean pass = false;
        short num = 1;
        short expectedResult = -1;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(num);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Short.class) && ExprEval.compareValue(result, expectedResult);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elIntegerUnaryTest() throws Exception {
        boolean pass = false;
        int num = 1;
        int expectedResult = -1;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(num);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Integer.class) && ExprEval.compareValue(result, expectedResult);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elLongUnaryTest() throws Exception {
        boolean pass = false;
        long num = 10000L;
        long expectedResult = -10000L;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(num);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue(result, expectedResult);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elFloatUnaryTest() throws Exception {
        boolean pass = false;
        float num = 10000.0f;
        float expectedResult = -10000.0f;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(Float.valueOf(num));
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Float.class) && ExprEval.compareValue((Float)result, Float.valueOf(expectedResult), 0);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elDoubleUnaryTest() throws Exception {
        boolean pass = false;
        double num = 10000.0;
        double expectedResult = -10000.0;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(num);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Double.class) && ExprEval.compareValue(result, expectedResult);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elBooleanUnaryFalseTest() throws Exception {
        this.testUnary("false", true);
    }

    @Test
    public void elBooleanUnaryTrueTest() throws Exception {
        this.testUnary("true", false);
    }

    private void testUnary(String testVal, boolean expectedResult) throws Exception {
        boolean pass = false;
        String[] operator = new String[]{"unary_not", "unary_bang"};
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(testVal);
        try {
            for (boolean tf : this.deferred) {
                for (String op : operator) {
                    String expr = ExprEval.buildElExpr(tf, op);
                    Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                    logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                    boolean bl = pass = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue((Boolean)result, expectedResult);
                    if (pass) continue;
                    throw new Exception("TEST FAILED: pass = false");
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

