/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.assignmentoperator;

import com.sun.ts.tests.el.common.util.TypesBean;
import com.sun.ts.tests.el.common.util.Validator;
import jakarta.el.ELProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elAssignmentOperatorBigDecimalTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "BigDecimal";
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String aValue = "a = types.tckBigDecimal";
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            elp.eval(aValue);
            elp.eval(bValue);
            Validator.testExpression(elp, "a + b", BigDecimal.valueOf(2L), comparitorA + " + " + bName);
            Validator.testExpression(elp, "a * b", BigDecimal.valueOf(1L), comparitorA + " * " + bName);
            Validator.testExpression(elp, "a - b", BigDecimal.valueOf(0L), comparitorA + " - " + bName);
            Validator.testExpression(elp, "a / b", BigDecimal.valueOf(1L), comparitorA + " / " + bName);
            Validator.testExpression(elp, "a div b", BigDecimal.valueOf(1L), comparitorA + " div " + bName);
            Validator.testExpression(elp, "a % b", 0.0, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a mod b", 0.0, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elAssignmentOperatorFloatTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Float";
        String aValue = "a = types.tckFloat";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(aValue);
            elp.eval(bValue);
            if ("BigInteger".equals(bName)) {
                Validator.testExpression(elp, "a + b", BigDecimal.valueOf(2L), comparitorA + " + " + bName);
                Validator.testExpression(elp, "a * b", BigDecimal.valueOf(1L), comparitorA + " * " + bName);
                Validator.testExpression(elp, "a - b", BigDecimal.valueOf(0L), comparitorA + " - " + bName);
                Validator.testExpression(elp, "a / b", BigDecimal.valueOf(1L), comparitorA + " / " + bName);
                Validator.testExpression(elp, "a div b", BigDecimal.valueOf(1L), comparitorA + " div " + bName);
            } else {
                Validator.testExpression(elp, "a + b", 2.0, comparitorA + " + " + bName);
                Validator.testExpression(elp, "a * b", 1.0, comparitorA + " * " + bName);
                Validator.testExpression(elp, "a - b", 0.0, comparitorA + " - " + bName);
                Validator.testExpression(elp, "a / b", 1.0, comparitorA + " / " + bName);
                Validator.testExpression(elp, "a div b", 1.0, comparitorA + " div " + bName);
            }
            Validator.testExpression(elp, "a % b", 0.0, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a mod b", 0.0, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elAssignmentOperatorDoubleTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Double";
        String aValue = "a = types.tckDouble";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("Float");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(aValue);
            elp.eval(bValue);
            if ("BigInteger".equals(bName)) {
                Validator.testExpression(elp, "a + b", BigDecimal.valueOf(2L), comparitorA + " + " + bName);
                Validator.testExpression(elp, "a * b", BigDecimal.valueOf(1L), comparitorA + " * " + bName);
                Validator.testExpression(elp, "a - b", BigDecimal.valueOf(0L), comparitorA + " - " + bName);
                Validator.testExpression(elp, "a / b", BigDecimal.valueOf(1L), comparitorA + " / " + bName);
                Validator.testExpression(elp, "a div b", BigDecimal.valueOf(1L), comparitorA + " div " + bName);
            } else {
                Validator.testExpression(elp, "a + b", 2.0, comparitorA + " + " + bName);
                Validator.testExpression(elp, "a * b", 1.0, comparitorA + " * " + bName);
                Validator.testExpression(elp, "a - b", 0.0, comparitorA + " - " + bName);
                Validator.testExpression(elp, "a / b", 1.0, comparitorA + " / " + bName);
                Validator.testExpression(elp, "a div b", 1.0, comparitorA + " div " + bName);
            }
            Validator.testExpression(elp, "a % b", 0.0, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a mod b", 0.0, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elAssignmentOperatorBigIntegerTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "BigInteger";
        String aValue = "a = types.tckBigInteger";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("Double");
        excludeList.add("Float");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(aValue);
            elp.eval(bValue);
            Validator.testExpression(elp, "a + b", BigInteger.valueOf(2L), comparitorA + " + " + bName);
            Validator.testExpression(elp, "a * b", BigInteger.valueOf(1L), comparitorA + " * " + bName);
            Validator.testExpression(elp, "a - b", BigInteger.valueOf(0L), comparitorA + " - " + bName);
            Validator.testExpression(elp, "a / b", BigDecimal.valueOf(1L), comparitorA + " / " + bName);
            Validator.testExpression(elp, "a div b", BigDecimal.valueOf(1L), comparitorA + " div " + bName);
            Validator.testExpression(elp, "a % b", BigInteger.valueOf(0L), comparitorA + " % " + bName);
            Validator.testExpression(elp, "a mod b", BigInteger.valueOf(0L), comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elAssignmentOperatorIntegerTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Integer";
        String aValue = "a = types.tckInteger";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Double");
        excludeList.add("Float");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(aValue);
            elp.eval(bValue);
            Validator.testExpression(elp, "a + b", 2L, comparitorA + " + " + bName);
            Validator.testExpression(elp, "a * b", 1L, comparitorA + " * " + bName);
            Validator.testExpression(elp, "a - b", 0L, comparitorA + " - " + bName);
            Validator.testExpression(elp, "a / b", 1.0, comparitorA + " / " + bName);
            Validator.testExpression(elp, "a div b", 1.0, comparitorA + " div " + bName);
            Validator.testExpression(elp, "a % b", 0L, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a mod b", 0L, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elAssignmentOperatorLongTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Long";
        String aValue = "a = types.tckLong";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(aValue);
            elp.eval(bValue);
            Validator.testExpression(elp, "a + b", 2L, comparitorA + " + " + bName);
            Validator.testExpression(elp, "a * b", 1L, comparitorA + " * " + bName);
            Validator.testExpression(elp, "a - b", 0L, comparitorA + " - " + bName);
            Validator.testExpression(elp, "a / b", 1.0, comparitorA + " / " + bName);
            Validator.testExpression(elp, "a div b", 1.0, comparitorA + " div " + bName);
            Validator.testExpression(elp, "a % b", 0L, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a mod b", 0L, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elAssignmentOperatorShortTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Short";
        String aValue = "a = types.tckShort";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        excludeList.add("Long");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(aValue);
            elp.eval(bValue);
            Validator.testExpression(elp, "a + b", 2L, comparitorA + " + " + bName);
            Validator.testExpression(elp, "a * b", 1L, comparitorA + " * " + bName);
            Validator.testExpression(elp, "a - b", 0L, comparitorA + " - " + bName);
            Validator.testExpression(elp, "a / b", 1.0, comparitorA + " / " + bName);
            Validator.testExpression(elp, "a div b", 1.0, comparitorA + " div " + bName);
            Validator.testExpression(elp, "a % b", 0L, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a mod b", 0L, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elAssignmentOperatorByteTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Byte";
        String aValue = "a = types.tckByte";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        excludeList.add("Long");
        excludeList.add("Short");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(aValue);
            elp.eval(bValue);
            Validator.testExpression(elp, "a + b", 2L, comparitorA + " + " + bName);
            Validator.testExpression(elp, "a * b", 1L, comparitorA + " * " + bName);
            Validator.testExpression(elp, "a - b", 0L, comparitorA + " - " + bName);
            Validator.testExpression(elp, "a / b", 1.0, comparitorA + " / " + bName);
            Validator.testExpression(elp, "a div b", 1.0, comparitorA + " div " + bName);
            Validator.testExpression(elp, "a % b", 0L, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a mod b", 0L, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elAssignmentOperatorNullTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        elp.defineBean("types", (Object)new TypesBean());
        Long expected = 0L;
        String aValue = "a = types.tckNull";
        String bValue = "b = types.tckNull";
        elp.eval(aValue);
        elp.eval(bValue);
        Validator.testExpression(elp, "a + b", expected, "null + null");
        Validator.testExpression(elp, "a - b", expected, "null - null");
        Validator.testExpression(elp, "a * b", expected, "null * null");
        Validator.testExpression(elp, "a / b", expected, "null / null");
        Validator.testExpression(elp, "a div b", expected, "null div null");
        Validator.testExpression(elp, "a % b", expected, "null % null");
        Validator.testExpression(elp, "a mod b", expected, "null mod null");
    }

    @Test
    public void elAssignmentOperatorMultiTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "BigDecimal";
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bName = bType.getSimpleName();
            String aValue = "a = types.tckBigDecimal";
            String bValue = TypesBean.getNumberMap().get(bType);
            String cValue = "c = types.tckBigDecimal";
            elp.eval(aValue);
            elp.eval(bValue);
            elp.eval(cValue);
            Validator.testExpression(elp, "a + b + c", BigDecimal.valueOf(3L), comparitorA + " + " + bName);
            Validator.testExpression(elp, "a * b + c", BigDecimal.valueOf(2L), comparitorA + " * " + bName);
            Validator.testExpression(elp, "a - b + c", BigDecimal.valueOf(1L), comparitorA + " - " + bName);
            Validator.testExpression(elp, "a / b + c", BigDecimal.valueOf(2L), comparitorA + " / " + bName);
            Validator.testExpression(elp, "a div b + c", BigDecimal.valueOf(2L), comparitorA + " div " + bName);
            Validator.testExpression(elp, "a % b + c", BigDecimal.valueOf(1L), comparitorA + " % " + bName);
            Validator.testExpression(elp, "a mod b + c", BigDecimal.valueOf(1L), comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }
}

