/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.ide.view.segments;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.util.VViewResourceFactoryImpl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.segments.EMFFormsSegmentGenerator;
import org.eclipse.emfforms.spi.ide.view.segments.DmrToSegmentsMigrationException;
import org.eclipse.emfforms.spi.ide.view.segments.DmrToSegmentsMigrator;
import org.eclipse.emfforms.view.spi.multisegment.model.MultiSegmentUtil;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultiDomainModelReferenceSegment;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class DmrToSegmentsMigratorImpl
implements DmrToSegmentsMigrator {
    private EMFFormsSegmentGenerator segmentGenerator;
    private ReportService reportService;

    @Reference(unbind="-")
    void setEMFFormsSegmentGenerator(EMFFormsSegmentGenerator segmentGenerator) {
        this.segmentGenerator = segmentGenerator;
    }

    @Reference(unbind="-")
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    public boolean needsMigration(URI resourceUri) {
        Resource resource;
        try {
            resource = this.loadResource(resourceUri);
        }
        catch (IOException ex) {
            this.reportService.report(new AbstractReport((Throwable)ex, "Could not check whether resource ''{0}'' still uses legacy DMRs because it could not be loaded.", new Object[]{resourceUri}));
            return false;
        }
        return this.needsMigration(resource);
    }

    protected boolean needsMigration(Resource resource) {
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            if (!this.isLegacyDmr(next)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void performMigration(URI resourceUri, DmrToSegmentsMigrator.PreReplaceProcessor ... preReplaceProcessors) throws DmrToSegmentsMigrationException {
        Resource resource;
        try {
            resource = this.loadResource(resourceUri);
        }
        catch (IOException ex) {
            throw new DmrToSegmentsMigrationException(ex, "The resource {0} could not be loaded", resourceUri);
        }
        this.performMigration(resource, preReplaceProcessors);
        try {
            resource.save(Collections.singletonMap("ENCODING", "UTF-8"));
        }
        catch (IOException ex) {
            throw new DmrToSegmentsMigrationException(ex, "Migrated resource could not be saved to {0}.", resourceUri);
        }
    }

    protected void performMigration(Resource resource, DmrToSegmentsMigrator.PreReplaceProcessor ... preReplaceProcessors) throws DmrToSegmentsMigrationException {
        LinkedList legacyDmrs = new LinkedList();
        TreeIterator allContents = resource.getAllContents();
        allContents.forEachRemaining(eObject -> {
            if (this.isLegacyDmr((EObject)eObject)) {
                legacyDmrs.add((VDomainModelReference)eObject);
                allContents.prune();
            }
        });
        for (VDomainModelReference legacyDmr : legacyDmrs) {
            List segments = this.segmentGenerator.generateSegments(legacyDmr);
            VDomainModelReference newDmr = VViewFactory.eINSTANCE.createDomainModelReference();
            newDmr.getSegments().addAll((Collection)segments);
            HashMap<VDomainModelReference, VDomainModelReference> crossRefReplacements = new HashMap<VDomainModelReference, VDomainModelReference>();
            crossRefReplacements.put(legacyDmr, newDmr);
            if (legacyDmr instanceof VTableDomainModelReference) {
                EList columnDmrs = ((VTableDomainModelReference)VTableDomainModelReference.class.cast(legacyDmr)).getColumnDomainModelReferences();
                EList childDmrs = MultiSegmentUtil.getMultiSegment((VDomainModelReference)newDmr).map(VMultiDomainModelReferenceSegment::getChildDomainModelReferences).orElseGet(BasicEList::new);
                if (columnDmrs.size() != childDmrs.size()) {
                    throw new DmrToSegmentsMigrationException("There was a different number of legacy column DMRs and generated child DMRs for table DMR {0}.", legacyDmr);
                }
                int i = 0;
                while (i < columnDmrs.size()) {
                    crossRefReplacements.put((VDomainModelReference)columnDmrs.get(i), (VDomainModelReference)childDmrs.get(i));
                    ++i;
                }
            }
            DmrToSegmentsMigrator.PreReplaceProcessor[] preReplaceProcessorArray = preReplaceProcessors;
            int n = preReplaceProcessors.length;
            int n2 = 0;
            while (n2 < n) {
                DmrToSegmentsMigrator.PreReplaceProcessor processor = preReplaceProcessorArray[n2];
                processor.process(legacyDmr, newDmr);
                ++n2;
            }
            EcoreUtil.replace((EObject)legacyDmr, (EObject)newDmr);
            Map usageMap = EcoreUtil.UsageCrossReferencer.findAll(crossRefReplacements.keySet(), (Resource)resource);
            usageMap.forEach((old, usages) -> usages.forEach(setting -> {
                VDomainModelReference replacement = (VDomainModelReference)crossRefReplacements.get(old);
                EcoreUtil.replace((EStructuralFeature.Setting)setting, (Object)old, (Object)replacement);
            }));
        }
    }

    private boolean isLegacyDmr(EObject eObject) {
        return VViewPackage.Literals.DOMAIN_MODEL_REFERENCE.isSuperTypeOf(eObject.eClass()) && VViewPackage.Literals.DOMAIN_MODEL_REFERENCE != eObject.eClass();
    }

    private Resource loadResource(URI resourceUri) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new VViewResourceFactoryImpl());
        Resource resource = resourceSet.createResource(resourceUri);
        resource.load(null);
        return resource;
    }
}

