/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest;

import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.debugging.model.EaseDebugVariable;
import org.eclipse.ease.lang.unittest.FilteredTestCommand;
import org.eclipse.ease.lang.unittest.UnitTestHelper;
import org.eclipse.ease.lang.unittest.definition.Flag;
import org.eclipse.ease.lang.unittest.definition.ITestSuiteDefinition;
import org.eclipse.ease.lang.unittest.definition.IVariable;
import org.eclipse.ease.lang.unittest.execution.DefaultTestExecutionStrategy;
import org.eclipse.ease.lang.unittest.runtime.IRuntimeFactory;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.service.ScriptType;

public class TestSuiteScriptEngine
extends AbstractScriptEngine
implements IDebugEngine {
    public static final String ENGINE_ID = "org.eclipse.ease.lang.unittest.engine";
    public static final String TEST_FILE_VARIABLE = "__EASE_UnitTest_File";
    public static final String TEST_SUITE_VARIABLE = "__EASE_UnitTest_Suite";
    private final Map<String, Object> fVariables = new HashMap<String, Object>();
    private final List<URL> fRegisteredJars = new ArrayList<URL>();
    private final ITestContainer fTestRoot = IRuntimeFactory.eINSTANCE.createTestFolder();
    private ILaunch fLaunch = null;
    private boolean fSuspendOnStartup;
    private boolean fSuspendOnScriptLoad;
    private boolean fShowDynamicCode;
    private boolean fTerminated = false;

    private static void printStatus(ITestEntity entity, String indent) {
        System.out.println(String.valueOf(indent) + entity.getClass().getSimpleName() + " <" + entity.getName() + "> : " + (Object)((Object)entity.getStatus()) + " (" + entity.getDuration() + " ms)");
        if (entity instanceof ITestContainer) {
            for (ITestEntity child : ((ITestContainer)entity).getChildren()) {
                TestSuiteScriptEngine.printStatus(child, String.valueOf(indent) + "\t");
            }
        }
    }

    public TestSuiteScriptEngine() {
        super("Script Testsuite");
        this.fTestRoot.setName("Root");
    }

    public void terminateCurrent() {
        this.terminate();
    }

    public void registerJar(URL url) {
        this.fRegisteredJars.add(url);
    }

    protected Object internalGetVariable(String name) {
        return this.fVariables.get(name);
    }

    protected Map<String, Object> internalGetVariables() {
        return this.fVariables;
    }

    protected boolean internalHasVariable(String name) {
        return this.internalGetVariables().containsKey(name);
    }

    protected void internalSetVariable(String name, Object content) {
        this.fVariables.put(name, content);
    }

    public Object removeVariable(String name) {
        return this.fVariables.remove(name);
    }

    protected void setupEngine() throws ScriptEngineException {
        this.fTerminated = false;
    }

    protected void teardownEngine() throws ScriptEngineException {
    }

    private ITestSuite loadTestSuiteDefinition(Script script) throws Exception {
        ITestSuiteDefinition definition = UnitTestHelper.loadTestSuite(script.getCodeStream());
        if (definition != null) {
            definition.setResource(script.getFile());
            ITestSuite runtimeSuite = UnitTestHelper.createRuntimeSuite(definition);
            runtimeSuite.setResource(definition.getResource());
            this.fTestRoot.getChildren().clear();
            this.fTestRoot.getChildren().add((Object)runtimeSuite);
            for (IVariable variable : definition.getVariables()) {
                this.setVariable(variable.getName(), variable.getContent());
            }
            return runtimeSuite;
        }
        return null;
    }

    protected Object execute(Script script, String fileName, boolean uiThread) throws Throwable {
        DefaultTestExecutionStrategy strategy;
        Object command = script.getCommand();
        if (!(command instanceof ITestEntity) && !(command instanceof FilteredTestCommand)) {
            try {
                ITestSuite runtimeSuite = this.loadTestSuiteDefinition(script);
                if (runtimeSuite == null) {
                    throw new Exception("Could not load suite from resource: " + script.getFile());
                }
                command = runtimeSuite;
            }
            catch (Exception e) {
                throw new Exception("Invalid testsuite content detected in: " + script.getFile(), e);
            }
        }
        if (command instanceof ITestEntity) {
            strategy = new DefaultTestExecutionStrategy();
            strategy.prepareExecution(this, (ITestEntity)command);
            strategy.execute((ITestEntity)command);
            return command;
        }
        if (command instanceof FilteredTestCommand) {
            strategy = new DefaultTestExecutionStrategy();
            strategy.prepareExecution(this, ((FilteredTestCommand)command).getTestRoot(), ((FilteredTestCommand)command).getActiveTests());
            strategy.execute(((FilteredTestCommand)command).getTestRoot());
            return command;
        }
        throw new Exception("Cannot execute object \"" + command + "\"");
    }

    public void setupDebugger(ILaunch launch, boolean suspendOnStartup, boolean suspendOnScriptLoad, boolean showDynamicCode) {
        this.fLaunch = launch;
        this.fSuspendOnStartup = suspendOnStartup;
        this.fSuspendOnScriptLoad = suspendOnScriptLoad;
        this.fShowDynamicCode = showDynamicCode;
    }

    public ITestContainer getTestRoot() {
        return this.fTestRoot;
    }

    public ScriptStackTrace getExceptionStackTrace() {
        return null;
    }

    public ScriptStackTrace getExceptionStackTrace(Object thread) {
        return null;
    }

    public void terminate() {
        if (!this.fTerminated) {
            this.fTerminated = true;
            if (this.getTestRoot() != null) {
                this.getTestRoot().setTerminated(true);
            }
            super.terminate();
        }
    }

    public IScriptEngine createScriptEngine(ITestSuite testSuite, Object resource) {
        String location;
        ScriptService scriptService = ScriptService.getInstance();
        EngineDescription candidate = null;
        if (testSuite != null && testSuite.getDefinition() != null && testSuite.getDefinition().getFlag(Flag.PREFERRED_ENGINE_ID, "") != null) {
            candidate = scriptService.getEngineByID(testSuite.getDefinition().getFlag(Flag.PREFERRED_ENGINE_ID, ""));
        }
        if (resource != null && (location = resource.toString()) != null && !location.isEmpty()) {
            ScriptType requiredScriptType = scriptService.getScriptType(location);
            List engines = requiredScriptType.getEngines();
            if (candidate != null) {
                for (EngineDescription description : engines) {
                    if (!candidate.equals(description)) continue;
                    return this.prepareEngine(description.createEngine());
                }
            }
            for (EngineDescription description : engines) {
                if (!description.supportsDebugging()) continue;
                return this.prepareEngine(description.createEngine());
            }
            if (!engines.isEmpty()) {
                return this.prepareEngine(((EngineDescription)engines.get(0)).createEngine());
            }
        }
        if (candidate != null) {
            return this.prepareEngine(candidate.createEngine());
        }
        return null;
    }

    private IScriptEngine prepareEngine(IScriptEngine engine) {
        engine.setOutputStream((OutputStream)this.getOutputStream());
        engine.setInputStream(this.getInputStream());
        engine.setErrorStream((OutputStream)this.getErrorStream());
        if (this.fLaunch != null && engine instanceof IDebugEngine) {
            ((IDebugEngine)engine).setupDebugger(this.fLaunch, this.fSuspendOnStartup, this.fSuspendOnScriptLoad, this.fShowDynamicCode);
        }
        for (Map.Entry variable : this.getVariables().entrySet()) {
            if (TEST_FILE_VARIABLE.equals(variable.getKey()) || TEST_SUITE_VARIABLE.equals(variable.getKey())) continue;
            engine.setVariable((String)variable.getKey(), variable.getValue());
        }
        for (URL jarLocation : this.fRegisteredJars) {
            engine.registerJar(jarLocation);
        }
        return engine;
    }

    public Collection<EaseDebugVariable> getVariables(Object scope) {
        throw new UnsupportedOperationException();
    }
}

