/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.scriptarchive.ui.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ease.lang.scriptarchive.ui.export.ArchiveFileExportOperation;
import org.eclipse.ease.lang.scriptarchive.ui.export.MainPage;
import org.eclipse.ease.lang.scriptarchive.ui.export.ManifestOutputStream;
import org.eclipse.ease.ui.Activator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ScriptArchiveExportWizard
extends Wizard
implements IExportWizard {
    private IStructuredSelection fSelection;
    private MainPage fMainPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = selection;
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("ExportScriptAction");
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("ExportScriptAction");
        }
        this.setDialogSettings(wizardSettings);
        this.setDefaultPageImageDescriptor(Activator.getImageDescriptor((String)"org.eclipse.ease.lang.scriptarchive.ui", (String)"/icons/wizban/export_script_archive_wiz.png"));
    }

    public void addPages() {
        super.addPages();
        this.fMainPage = new MainPage("Script Archive Export", "Executable Script Archive", null, this.fSelection);
        this.addPage((IWizardPage)this.fMainPage);
    }

    public boolean performFinish() {
        boolean overwrite;
        IProject project = this.fMainPage.getSelectedProject();
        IFile startupScript = this.fMainPage.getSelectedFile();
        File targetFile = this.fMainPage.getTargetFile();
        if (targetFile.exists() && !(overwrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Question", (String)"Target file already exists. Would you like to overwrite it?"))) {
            return false;
        }
        if (!targetFile.getParentFile().exists()) {
            boolean createTargetDir = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Question", (String)"Target directory does not exist. Would you like to create it?");
            if (!createTargetDir) {
                return false;
            }
            if (!targetFile.getParentFile().mkdirs()) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"", null, (IStatus)new Status(4, "org.eclipse.ease.lang.scriptarchive.ui", "Could not create target directories"));
                return false;
            }
        }
        String startupLocation = startupScript.getFullPath().removeFirstSegments(1).toPortableString();
        IFile manifest = project.getFile((IPath)new Path("/META-INF/MANIFEST.MF"));
        Properties properties = new Properties();
        if (manifest.exists()) {
            try {
                properties.load(manifest.getContents());
            }
            catch (IOException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"", null, (IStatus)new Status(4, "org.eclipse.ease.lang.scriptarchive.ui", "Error reading project manifest", (Throwable)e));
                return false;
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"", null, (IStatus)new Status(4, "org.eclipse.ease.lang.scriptarchive.ui", "Error reading project manifest", (Throwable)e));
                return false;
            }
        }
        try {
            if (!startupLocation.equals(properties.get("Main-Script"))) {
                properties.put("Main-Script", startupLocation);
                ByteArrayOutputStream manifestContent = new ByteArrayOutputStream();
                new ManifestOutputStream(manifestContent).writeManifest(properties.entrySet());
                if (manifest.exists()) {
                    manifest.setContents((InputStream)new ByteArrayInputStream(manifestContent.toByteArray()), false, false, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    if (!manifest.getParent().exists()) {
                        ((IFolder)manifest.getParent()).create(true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    manifest.create((InputStream)new ByteArrayInputStream(manifestContent.toByteArray()), false, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"", null, (IStatus)new Status(4, "org.eclipse.ease.lang.scriptarchive.ui", "Error modifying project manifest", (Throwable)e));
            return false;
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"", null, (IStatus)new Status(4, "org.eclipse.ease.lang.scriptarchive.ui", "Error updating project manifest", (Throwable)e));
            return false;
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true);
        this.saveWidgetValues();
        try {
            ArchiveFileExportOperation archiveFileExportOperation = new ArchiveFileExportOperation(Arrays.asList(project.members()), targetFile.getAbsolutePath());
            return this.executeExportOperation(archiveFileExportOperation);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"", null, (IStatus)new Status(4, "org.eclipse.ease.lang.scriptarchive.ui", "Could not parse project content", (Throwable)e));
            return false;
        }
    }

    private void saveWidgetValues() {
        String locationEntry = this.fMainPage.getTargetFile().getAbsolutePath();
        if (locationEntry != null && !locationEntry.isEmpty()) {
            String[] lastLocations = this.getDialogSettings().getArray("Last path");
            if (lastLocations == null) {
                this.getDialogSettings().put("Last path", new String[]{this.fMainPage.getTargetFile().getAbsolutePath()});
            } else {
                ArrayList<String> locations = new ArrayList<String>(Arrays.asList(lastLocations));
                if (!locations.contains(this.fMainPage.getTargetFile().getAbsolutePath())) {
                    locations.add(0, this.fMainPage.getTargetFile().getAbsolutePath());
                }
                this.getDialogSettings().put("Last path", locations.subList(0, Math.min(locations.size(), 5)).toArray(new String[locations.size()]));
            }
        }
    }

    protected boolean executeExportOperation(ArchiveFileExportOperation op) {
        op.setCreateLeadupStructure(true);
        op.setUseCompression(true);
        op.setIncludeLinkedResources(true);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException().getMessage());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Export problems", null, (IStatus)status);
            return false;
        }
        return true;
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)"Script export error", (String)message, (int)0x10000000);
    }
}

